/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.item.ILeftClickReact;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.network.ServerBoundItemLeftClickMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;

    @Inject(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;", shift=At.Shift.BEFORE)}, cancellable=true)
    private void moonlight$onItemLeftClick(CallbackInfoReturnable<Boolean> cir) {
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack stack = this.player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof ILeftClickReact) {
            ILeftClickReact lr = (ILeftClickReact)item;
            boolean cancel = lr.onLeftClick(stack, (Player)this.player, hand);
            NetworkHelper.sendToServer(new ServerBoundItemLeftClickMessage(hand));
            if (cancel) {
                this.player.swing(InteractionHand.MAIN_HAND);
                cir.setReturnValue((Object)false);
            }
        }
    }
}

