/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.milky_way.core;

import com.davigj.milky_way.core.MWConfig;
import com.davigj.milky_way.core.other.MWDataMapUtil;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@Mod(value="milky_way")
public class MilkyWay {
    public static final String MOD_ID = "milky_way";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("milky_way");
    public static final TrackedData<Map<Byte, Integer>> MILK_TIMERS = TrackedData.Builder.create((StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, Map<Byte, Integer>>(){

        public void encode(RegistryFriendlyByteBuf buf, Map<Byte, Integer> value) {
            buf.writeVarInt(value.size());
            for (Map.Entry<Byte, Integer> entry : value.entrySet()) {
                buf.writeByte(entry.getKey().byteValue());
                buf.writeVarInt(entry.getValue().intValue());
            }
        }

        public Map<Byte, Integer> decode(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            HashMap<Byte, Integer> map = new HashMap<Byte, Integer>(size);
            for (int i = 0; i < size; ++i) {
                byte key = buf.readByte();
                int val = buf.readVarInt();
                map.put(key, val);
            }
            return map;
        }
    }, () -> new HashMap<Byte, Integer>(Map.of((byte)0, 0))).build();

    public MilkyWay(IEventBus bus, ModContainer container) {
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::registerDataMapTypes);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MWConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TrackedDataManager.INSTANCE.registerData(MilkyWay.location("milk_timers"), MILK_TIMERS);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void dataSetup(GatherDataEvent event) {
    }

    private void registerDataMapTypes(RegisterDataMapTypesEvent event) {
        event.register(MWDataMapUtil.MILK_DATA);
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

