/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui;

import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.client.config.gui.ConfigScreen;
import io.github.jamalam360.jamlib.client.config.gui.SelectionList;
import io.github.jamalam360.jamlib.client.config.gui.SelectionListEntry;
import io.github.jamalam360.jamlib.config.ConfigManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SelectConfigScreen
extends Screen {
    private final String modId;
    private final Screen parent;

    public SelectConfigScreen(Screen parent, String modId) {
        super(SelectConfigScreen.createTitle(modId));
        this.parent = parent;
        this.modId = modId;
    }

    private static Component createTitle(String modId) {
        String translationKey = "config." + modId + ".title";
        if (I18n.exists((String)translationKey)) {
            return Component.translatable((String)translationKey);
        }
        return Component.translatable((String)"config.jamlib.selection_screen_title", (Object[])new Object[]{Platform.getMod((String)modId).getName()});
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> Objects.requireNonNull(this.minecraft).setScreen(this.parent)).pos(this.width / 2 - 75, this.height - 28).size(150, 20).build());
        ConfigSelectionList list = new ConfigSelectionList(this.minecraft, this.width, this.height - 64, 32, 25);
        ConfigManager.MANAGERS.values().stream().filter(m -> m.getModId().equals(this.modId)).forEach(list::addEntry);
        this.addRenderableWidget((GuiEventListener)list);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(Minecraft.getInstance().font, this.title, this.width / 2, 12, 0xFFFFFF);
    }

    private static class ConfigSelectionList
    extends SelectionList {
        public ConfigSelectionList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
        }

        private void addEntry(ConfigManager<?> manager) {
            List tooltip = null;
            String tooltipTranslationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), "tooltip");
            if (I18n.exists((String)tooltipTranslationKey)) {
                tooltip = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)tooltipTranslationKey), 200);
            }
            this.addEntry((AbstractSelectionList.Entry)new SelectionListEntry(ConfigScreen.createTitle(manager), tooltip, List.of(Button.builder((Component)Component.translatable((String)"config.jamlib.open"), b -> this.minecraft.setScreen(new ConfigScreen(manager, this.minecraft.screen))).pos(this.width - 160, this.height - 28).size(150, 20).build())));
        }
    }
}

