/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.block;

import java.util.function.Supplier;
import net.baffledbanana87.endervillages.block.custom.DragonFruitBlock;
import net.baffledbanana87.endervillages.block.custom.EndCropBlock;
import net.baffledbanana87.endervillages.block.custom.EnderCarrotBlock;
import net.baffledbanana87.endervillages.block.custom.EnderPotatoBlock;
import net.baffledbanana87.endervillages.block.custom.WarpEnchantingBlock;
import net.baffledbanana87.endervillages.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlock {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"endervillages");
    public static final DeferredBlock<Block> WARP_BLOCK = ModBlock.registerBlock("warp_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.COW_BELL).strength(0.5f).sound(SoundType.SOUL_SAND)));
    public static final DeferredBlock<Block> END_PATH_BLOCK = ModBlock.registerBlock("end_path", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.COW_BELL).strength(0.5f).sound(SoundType.SOUL_SAND)));
    public static final DeferredBlock<Block> END_COMPOSTER = ModBlock.registerBlock("end_composter", () -> new ComposterBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> ENDER_CARROT = ModBlock.registerBlock("ender_carrots", () -> new EnderCarrotBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> DRAGON_PLANT = ModBlock.registerBlock("dragon_plant", () -> new DragonFruitBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().strength(0.5f).sound(SoundType.CROP)));
    public static final DeferredBlock<Block> ENDER_POTATO = ModBlock.registerBlock("ender_potatoes", () -> new EnderPotatoBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<HayBlock> END_HAY_BLOCK = ModBlock.registerBlock("end_hay_block", () -> new HayBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BANJO).strength(0.5f).sound(SoundType.GRASS)));
    public static final DeferredBlock<Block> ENDER_WHEAT = ModBlock.registerBlock("end_wheat", () -> new EndCropBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> WARP_ENCHANTING_TABLE = ModBlock.registerBlock("warp_enchanting_table", () -> new WarpEnchantingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).lightLevel(p_152692_ -> 7).strength(-1.0f, 3600000.0f).noLootTable()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlock.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

