/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.block.custom;

import com.mojang.serialization.MapCodec;
import net.baffledbanana87.endervillages.block.ModBlockTags;
import net.baffledbanana87.endervillages.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;

public class DragonFruitBlock
extends CropBlock {
    public static final MapCodec<DragonFruitBlock> CODEC = DragonFruitBlock.simpleCodec(DragonFruitBlock::new);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};

    public MapCodec<DragonFruitBlock> codec() {
        return CODEC;
    }

    public DragonFruitBlock(BlockBehaviour.Properties p_51328_) {
        super(p_51328_);
    }

    protected boolean canSurvive(BlockState p_48986_, LevelReader p_48987_, BlockPos p_48988_) {
        return p_48987_.getBlockState(p_48988_.below()).is(ModBlockTags.ENDER_FOOD_PLANTABLE);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.DRAGON_FRUIT.get();
    }

    protected VoxelShape getShape(BlockState p_51330_, BlockGetter p_51331_, BlockPos p_51332_, CollisionContext p_51333_) {
        return SHAPE_BY_AGE[this.getAge(p_51330_)];
    }

    protected ItemInteractionResult useItemOn(ItemStack p_316383_, BlockState p_316676_, Level p_316272_, BlockPos p_316484_, Player p_316367_, InteractionHand p_316216_, BlockHitResult p_316827_) {
        if (!p_316383_.canPerformAction(ItemAbilities.SHEARS_CARVE)) {
            return super.useItemOn(p_316383_, p_316676_, p_316272_, p_316484_, p_316367_, p_316216_, p_316827_);
        }
        if (p_316272_.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)p_316272_.isClientSide);
        }
        Direction direction = p_316827_.getDirection();
        Direction direction1 = direction.getAxis() == Direction.Axis.Y ? p_316367_.getDirection().getOpposite() : direction;
        p_316272_.playSound((Player)null, p_316484_, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        p_316272_.setBlock(p_316484_, this.getStateForAge(0), 2);
        ItemEntity itementity = new ItemEntity(p_316272_, (double)p_316484_.getX() + 0.5 + (double)direction1.getStepX() * 0.65, (double)p_316484_.getY() + 0.1, (double)p_316484_.getZ() + 0.5 + (double)direction1.getStepZ() * 0.65, new ItemStack((ItemLike)ModItems.DRAGON_FRUIT.get(), 1));
        itementity.setDeltaMovement(0.05 * (double)direction1.getStepX() + p_316272_.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.getStepZ() + p_316272_.random.nextDouble() * 0.02);
        p_316272_.addFreshEntity((Entity)itementity);
        p_316383_.hurtAndBreak(1, (LivingEntity)p_316367_, LivingEntity.getSlotForHand((InteractionHand)p_316216_));
        p_316272_.gameEvent((Entity)p_316367_, (Holder)GameEvent.SHEAR, p_316484_);
        p_316367_.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
        return ItemInteractionResult.sidedSuccess((boolean)p_316272_.isClientSide);
    }
}

