/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies;

import immersive_melodies.Client;
import immersive_melodies.Common;
import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

public class MidiListener {
    public static void launch() {
        new Thread(new MidiListenerThread()).start();
    }

    static class MidiListenerThread
    implements Runnable {
        private final Set<MidiDevice.Info> connectedDevices = new ConcurrentSet();

        MidiListenerThread() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    MidiDevice.Info[] midiDevices;
                    for (MidiDevice.Info info : midiDevices = MidiSystem.getMidiDeviceInfo()) {
                        try {
                            MidiDevice device;
                            if (this.connectedDevices.contains(info) || (device = MidiSystem.getMidiDevice(info)).getMaxTransmitters() == 0) continue;
                            device.open();
                            Transmitter transmitter = device.getTransmitter();
                            transmitter.setReceiver(new MidiReceiver(this.connectedDevices, info));
                            Common.LOGGER.info("MIDI Device: {} - {}", (Object)info.getName(), (Object)info.getDescription());
                            this.connectedDevices.add(info);
                        }
                        catch (MidiUnavailableException e) {
                            Common.LOGGER.warn("MIDI Device unavailable: {}", (Object)info.getName(), (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    Common.LOGGER.error("Error initializing MIDI devices", (Throwable)e);
                }
            }
        }
    }

    static class MidiReceiver
    implements Receiver {
        private final Set<MidiDevice.Info> connectedDevices;
        private final MidiDevice.Info info;

        public MidiReceiver(Set<MidiDevice.Info> connectedDevices, MidiDevice.Info info) {
            this.connectedDevices = connectedDevices;
            this.info = info;
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            if (message instanceof ShortMessage) {
                ShortMessage sm = (ShortMessage)message;
                int command = sm.getCommand();
                if (command == 144) {
                    int note = sm.getData1();
                    int velocity = sm.getData2();
                    Client.playNote(note, velocity);
                } else if (command == 128) {
                    int note = sm.getData1();
                    Client.playNote(note, 0);
                }
            }
        }

        @Override
        public void close() {
            this.connectedDevices.remove(this.info);
        }
    }
}

