/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.gui.widget;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class DefaultButtonWidget
extends Button {
    private final Supplier<List<FormattedCharSequence>> tooltipSupplier;

    public DefaultButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        this(x, y, width, height, message, onPress, null);
    }

    public DefaultButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress, Supplier<List<FormattedCharSequence>> tooltipSupplier) {
        super(x, y, width, height, message, onPress, Supplier::get);
        this.tooltipSupplier = tooltipSupplier;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        if (this.visible) {
            this.updateTooltip();
        }
    }

    private void updateTooltip() {
        Screen screen;
        if (this.tooltipSupplier != null && this.isHovered() && (screen = Minecraft.getInstance().screen) != null) {
            screen.setTooltipForNextRenderPass(this.tooltipSupplier.get());
        }
    }
}

