/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.mixin;

import immersive_melodies.item.InstrumentItem;
import immersive_melodies.util.EntityEquiper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class}, priority=900)
public class ServerWorldMixin {
    @Inject(method={"addEntity"}, at={@At(value="HEAD")})
    private void onAddEntity(Entity entity, CallbackInfoReturnable<Boolean> info) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityEquiper.equip(livingEntity);
        }
    }

    @Inject(method={"tickNonPassenger"}, at={@At(value="HEAD")})
    public void immersiveMelodies$injectTickEntity(Entity entity, CallbackInfo ci) {
        this.immersiveMelodies$tick(entity);
    }

    @Inject(method={"tickPassenger"}, at={@At(value="HEAD")})
    public void immersiveMelodies$injectTickPassenger(Entity entity, Entity passenger, CallbackInfo ci) {
        this.immersiveMelodies$tick(passenger);
    }

    @Unique
    private void immersiveMelodies$tick(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getHandSlots().forEach(itemStack -> {
                Item patt0$temp = itemStack.getItem();
                if (patt0$temp instanceof InstrumentItem) {
                    InstrumentItem item = (InstrumentItem)patt0$temp;
                    item.inventoryServerTick((ItemStack)itemStack, (ServerLevel)this, entity);
                }
            });
        }
    }
}

