/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.c2s;

import immersive_melodies.Common;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.network.ImmersivePayload;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ItemActionMessage(int slot, State state, ResourceLocation melody) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<ItemActionMessage> TYPE = new CustomPacketPayload.Type(Common.locate("item_action_message"));
    public static final StreamCodec<FriendlyByteBuf, ItemActionMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ItemActionMessage::slot, State.STREAM_CODEC, ItemActionMessage::state, (StreamCodec)ResourceLocation.STREAM_CODEC, ItemActionMessage::melody, ItemActionMessage::new);

    public static ItemActionMessage fromStateAndMelody(State state, ResourceLocation melody) {
        LocalPlayer player = Minecraft.getInstance().player;
        int slot = player == null ? -1 : player.getInventory().selected;
        return new ItemActionMessage(slot, state, melody);
    }

    public static ItemActionMessage fromState(State state) {
        LocalPlayer player = Minecraft.getInstance().player;
        int slot = player == null ? -1 : player.getInventory().selected;
        return new ItemActionMessage(slot, state, ResourceLocation.withDefaultNamespace((String)"empty"));
    }

    @Override
    public void handle(Player e) {
        ItemStack stack = e.getInventory().getItem(this.slot);
        Item item = stack.getItem();
        if (item instanceof InstrumentItem) {
            InstrumentItem instrument = (InstrumentItem)item;
            switch (this.state.ordinal()) {
                case 0: {
                    instrument.play(stack, this.melody, e.level(), (Entity)e);
                    break;
                }
                case 1: {
                    instrument.play(stack);
                    break;
                }
                case 2: {
                    instrument.pause(stack);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum State {
        PLAY(0),
        CONTINUE(1),
        PAUSE(2);

        private final int id;
        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.continuous(State::id, (Object[])State.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

