/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.c2s;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.network.FragmentedMessage;
import immersive_melodies.network.Network;
import immersive_melodies.network.PacketSplitter;
import immersive_melodies.network.s2c.MelodyListMessage;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.ServerMelodyManager;
import immersive_melodies.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record UploadMelodyRequest(String name, byte[] fragment, int length) implements FragmentedMessage
{
    public static final CustomPacketPayload.Type<UploadMelodyRequest> TYPE = new CustomPacketPayload.Type(Common.locate("upload_melody_request"));
    public static final StreamCodec<FriendlyByteBuf, UploadMelodyRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, UploadMelodyRequest::name, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, UploadMelodyRequest::fragment, (StreamCodec)ByteBufCodecs.INT, UploadMelodyRequest::length, UploadMelodyRequest::new);

    @Override
    public void finish(Player e, String name, Melody melody) {
        if (!e.hasPermissions(Config.getInstance().uploadPermissionLevel)) {
            e.sendSystemMessage((Component)Component.translatable((String)"immersive_melodies.error.upload.no_permission"));
            return;
        }
        String id = Utils.getPlayerName(e) + "/" + Utils.escapeString(name);
        ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)"player", (String)id);
        ServerMelodyManager.registerMelody(identifier, melody);
        Network.sendToPlayer(new MelodyListMessage(e), (ServerPlayer)e);
        e.level().players().forEach(player -> PacketSplitter.sendToPlayer(identifier, melody, (ServerPlayer)player));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

