/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.Common;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.MelodyLoader;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.LevelStorageSource;

public class ServerMelodyManager {
    static final Random RANDOM = new Random();
    public static MinecraftServer server;
    private static Map<ResourceLocation, MelodyLoader.LazyMelody> datapackMelodies;
    private static File directory;

    public static void instantiate(ServerLevel world, LevelStorageSource.LevelStorageAccess session) {
        directory = session.getDimensionPath(world.dimension()).resolve("data/melodies").toFile();
    }

    private static File getFile(String id) {
        File file = new File(directory, id.replace(":", "/") + ".bin");
        file.getParentFile().mkdirs();
        return file;
    }

    public static CustomServerMelodiesIndex getIndex() {
        return (CustomServerMelodiesIndex)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(CustomServerMelodiesIndex::new, CustomServerMelodiesIndex::fromNbt, null), "immersive_melodies");
    }

    public static MelodyTrackSettings getSettings() {
        return (MelodyTrackSettings)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(MelodyTrackSettings::new, MelodyTrackSettings::fromNbt, null), "immersive_melodies_settings");
    }

    public static Map<ResourceLocation, MelodyLoader.LazyMelody> getDatapackMelodies() {
        return datapackMelodies;
    }

    public static void setDatapackMelodies(Map<ResourceLocation, MelodyLoader.LazyMelody> datapackMelodies) {
        ServerMelodyManager.datapackMelodies = datapackMelodies;
    }

    public static ResourceLocation getRandomMelody() {
        Object[] custom;
        Object[] datapack = ServerMelodyManager.getDatapackMelodies().keySet().toArray();
        if (datapack.length + (custom = ServerMelodyManager.getIndex().melodies.keySet().toArray()).length == 0) {
            return Common.locate("missing");
        }
        int i = RANDOM.nextInt(datapack.length + custom.length);
        if (i < datapack.length) {
            return (ResourceLocation)datapack[i];
        }
        return (ResourceLocation)custom[i - datapack.length];
    }

    public static void registerMelody(ResourceLocation identifier, Melody melody) {
        ServerMelodyManager.getIndex().getMelodies().put(identifier, melody);
        ServerMelodyManager.getIndex().setDirty(true);
        try {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            Melody.STREAM_CODEC.encode((Object)buffer, (Object)melody);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(ServerMelodyManager.getFile(identifier.toString())));
            bos.write(buffer.array());
            bos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteMelody(ResourceLocation identifier) {
        ServerMelodyManager.getIndex().getMelodies().remove(identifier);
        ServerMelodyManager.getIndex().setDirty(true);
        try {
            Files.delete(ServerMelodyManager.getFile(identifier.toString()).toPath());
        }
        catch (IOException e) {
            Common.LOGGER.error("Couldn't delete melody {} ({})", (Object)identifier, (Object)e);
        }
    }

    public static Melody getMelody(ResourceLocation identifier) {
        if (datapackMelodies.containsKey(identifier)) {
            return datapackMelodies.get(identifier).get();
        }
        Melody melody = Melody.DEFAULT;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(ServerMelodyManager.getFile(identifier.toString())));
            melody = (Melody)Melody.STREAM_CODEC.decode((Object)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bis.readAllBytes())));
        }
        catch (Exception e) {
            Common.LOGGER.error("Couldn't load melody {} ({})", (Object)identifier, (Object)e);
            ServerMelodyManager.deleteMelody(identifier);
        }
        return melody;
    }

    public static String getIdentifier(Entity entity, Item item) {
        return ServerMelodyManager.getIdentifier(entity, BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static String getIdentifier(Entity entity, ResourceLocation instrument) {
        return instrument.toString();
    }

    static {
        datapackMelodies = new HashMap<ResourceLocation, MelodyLoader.LazyMelody>();
        directory = new File("data/melodies");
    }

    public static class CustomServerMelodiesIndex
    extends SavedData {
        final Map<ResourceLocation, MelodyDescriptor> melodies = new HashMap<ResourceLocation, MelodyDescriptor>();

        public static CustomServerMelodiesIndex fromNbt(CompoundTag nbt, HolderLookup.Provider provider) {
            CustomServerMelodiesIndex c = new CustomServerMelodiesIndex();
            for (String key : nbt.getAllKeys()) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])nbt.getByteArray(key)));
                c.melodies.put(ResourceLocation.parse((String)key), (MelodyDescriptor)MelodyDescriptor.STREAM_CODEC.decode((Object)buffer));
            }
            return c;
        }

        public CompoundTag save(CompoundTag c, HolderLookup.Provider provider) {
            for (Map.Entry<ResourceLocation, MelodyDescriptor> entry : this.melodies.entrySet()) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                MelodyDescriptor.STREAM_CODEC.encode((Object)buffer, (Object)entry.getValue());
                c.putByteArray(entry.getKey().toString(), buffer.array());
            }
            return c;
        }

        public Map<ResourceLocation, MelodyDescriptor> getMelodies() {
            return this.melodies;
        }
    }

    public static class MelodyTrackSettings
    extends SavedData {
        final Map<ResourceLocation, Map<String, Set<Integer>>> enabledTracks = new HashMap<ResourceLocation, Map<String, Set<Integer>>>();

        public static MelodyTrackSettings fromNbt(CompoundTag nbt, HolderLookup.Provider provider) {
            MelodyTrackSettings c = new MelodyTrackSettings();
            for (String key : nbt.getAllKeys()) {
                CompoundTag map = nbt.getCompound(key);
                HashMap m = new HashMap();
                for (String k : map.getAllKeys()) {
                    CompoundTag set = map.getCompound(k);
                    HashSet<Integer> s = new HashSet<Integer>();
                    for (String i : set.getAllKeys()) {
                        s.add(set.getInt(i));
                    }
                    m.put(k, s);
                }
                c.enabledTracks.put(ResourceLocation.parse((String)key), m);
            }
            return c;
        }

        public CompoundTag save(CompoundTag c, HolderLookup.Provider provider) {
            for (Map.Entry<ResourceLocation, Map<String, Set<Integer>>> entry : this.enabledTracks.entrySet()) {
                CompoundTag map = new CompoundTag();
                for (Map.Entry<String, Set<Integer>> e : entry.getValue().entrySet()) {
                    CompoundTag set = new CompoundTag();
                    for (int i : e.getValue()) {
                        set.putInt(e.getKey(), i);
                    }
                    map.put(e.getKey(), (Tag)set);
                }
                c.put(entry.getKey().toString(), (Tag)map);
            }
            return c;
        }

        public void enableTrack(ResourceLocation melody, String identifier, int track) {
            this.enabledTracks.computeIfAbsent(melody, k -> new HashMap()).computeIfAbsent(identifier, k -> new HashSet()).add(track);
            this.setDirty(true);
        }

        public void disableTrack(ResourceLocation melody, String identifier, int track) {
            Map uuidSetMap = this.enabledTracks.computeIfAbsent(melody, k -> new HashMap());
            uuidSetMap.computeIfAbsent(identifier, k -> new HashSet()).remove(track);
            this.setDirty(true);
        }

        public Set<Integer> getEnabledTracks(ResourceLocation name, String identifier) {
            Map playerSettings = this.enabledTracks.getOrDefault(name, Collections.emptyMap());
            return playerSettings.getOrDefault(identifier, playerSettings.values().stream().findFirst().orElse(Set.of()));
        }
    }
}

