/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.resources.Note;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Track {
    private final String name;
    private final List<Note> notes;
    public static StreamCodec<FriendlyByteBuf, Track> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Track::getName, (StreamCodec)Note.STREAM_CODEC.apply(ByteBufCodecs.list()), Track::getNotes, Track::new);

    public Track(String name, List<Note> notes) {
        this.name = name;
        this.notes = notes;
    }

    public List<Note> getNotes() {
        return Collections.unmodifiableList(this.notes);
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        if (this.notes.isEmpty()) {
            return 0;
        }
        Note note = this.notes.getLast();
        return note.getTime() + note.getLength();
    }

    public void setNotes(List<Note> notes) {
        this.notes.clear();
        this.notes.addAll(notes);
    }
}

