/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.alpinewhispers.client.model.armor.WinterHatModel;
import net.satisfy.alpinewhispers.client.model.entity.AlpineSheepModel;
import net.satisfy.alpinewhispers.client.model.entity.ReindeerModel;
import net.satisfy.alpinewhispers.client.renderer.block.BathtubRenderer;
import net.satisfy.alpinewhispers.client.renderer.block.TreeBaublesRenderer;
import net.satisfy.alpinewhispers.client.renderer.block.WardrobeRenderer;
import net.satisfy.alpinewhispers.client.renderer.entity.AlpineSheepRenderer;
import net.satisfy.alpinewhispers.client.renderer.entity.ChairRenderer;
import net.satisfy.alpinewhispers.client.renderer.entity.ReindeerRenderer;
import net.satisfy.alpinewhispers.client.renderer.model.BathtubModel;
import net.satisfy.alpinewhispers.client.weather.GroveSnowWeather;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public class AlpineWhispersClient {
    public static void onInitializeClient() {
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)ObjectRegistry.COOKED_REINDEER_DISH_BLOCK.get(), (Block)ObjectRegistry.HOMESPUN_CARPET.get(), (Block)ObjectRegistry.TREE_BAUBLES.get(), (Block)ObjectRegistry.SNOW_GLOBE.get(), (Block)ObjectRegistry.ICICLES.get(), (Block)ObjectRegistry.HOARFROST_GRASS.get(), (Block)ObjectRegistry.TALL_HOARFROST_GRASS.get(), (Block)ObjectRegistry.CHRISTMAS_ROSE.get(), (Block)ObjectRegistry.POTTED_CHRISTMAS_ROSE.get(), (Block)ObjectRegistry.SNOW_GENTIAN.get(), (Block)ObjectRegistry.POTTED_SNOW_GENTIAN.get(), (Block)ObjectRegistry.AROLLA_PINE_SAPLING.get(), (Block)ObjectRegistry.STAR_TOPPER.get(), (Block)ObjectRegistry.GARLAND.get(), (Block)ObjectRegistry.CANDLE_WREATH.get(), (Block)ObjectRegistry.WALL_WREATH.get(), (Block)ObjectRegistry.FAIRY_LIGHTS.get(), (Block)ObjectRegistry.AROLLA_PINE_WARDROBE.get(), (Block)ObjectRegistry.AROLLA_PINE_SINK.get(), (Block)ObjectRegistry.AROLLA_PINE_WASHBASIN.get(), (Block)ObjectRegistry.AROLLA_PINE_BATHTUB.get(), (Block)ObjectRegistry.AROLLA_PINE_TABLE.get(), (Block)ObjectRegistry.AROLLA_PINE_CHAIR.get(), (Block)ObjectRegistry.AROLLA_PINE_SOFA.get(), (Block)ObjectRegistry.FIREPLACE_CORNICE.get(), (Block)ObjectRegistry.AROLLA_PINE_WINDOW.get(), (Block)ObjectRegistry.AROLLA_PINE_WINDOW_PANE.get(), (Block)ObjectRegistry.AROLLA_PINE_DOOR.get(), (Block)ObjectRegistry.AROLLA_PINE_TRAPDOOR.get()});
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.getAverageWaterColor((BlockAndTintGetter)world, (BlockPos)pos);
        }, (Block[])new Block[]{(Block)ObjectRegistry.AROLLA_PINE_SINK.get(), (Block)ObjectRegistry.AROLLA_PINE_WASHBASIN.get()});
        AlpineWhispersClient.registerBlockEntityRenderer();
        GroveSnowWeather.init();
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.CHAIR_ENTITY, ChairRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.REINDEER_ENTITY, ReindeerRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.ALPINE_SHEEP_ENTITY, AlpineSheepRenderer::new);
    }

    public static void preInitClient() {
        AlpineWhispersClient.registerEntityRenderers();
        AlpineWhispersClient.registerEntityModelLayer();
    }

    public static void registerEntityModelLayer() {
        EntityModelLayerRegistry.register((ModelLayerLocation)WinterHatModel.LAYER_LOCATION, WinterHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BathtubModel.LAYER_LOCATION, BathtubModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)ReindeerModel.LAYER_LOCATION, ReindeerModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)AlpineSheepModel.LAYER_LOCATION, AlpineSheepModel::getTexturedModelData);
    }

    public static void registerBlockEntityRenderer() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.TREE_BAUBLES_BLOCK_ENTITY.get()), ctx -> new TreeBaublesRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.BATHTUB_BLOCK_ENTITY.get()), BathtubRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.WARDROBE_BLOCK_ENTITY.get()), WardrobeRenderer::new);
    }
}

