/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client.model.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.core.registry.ObjectRegistry;

public class WinterHatModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(AlpineWhispers.identifier("winter_hat"), "main");
    private static final Map<Item, WinterHatModel<?>> MODELS = new HashMap();
    private final ModelPart winter_hat;

    public WinterHatModel(ModelPart root) {
        this.winter_hat = root.getChild("winter_hat");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition winter_hat = partdefinition.addOrReplaceChild("winter_hat", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -9.0f, -4.5f, 9.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(-3.5f, -11.0f, -3.5f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(21, 11).addBox(-1.5f, -12.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int k) {
        poseStack.pushPose();
        this.winter_hat.render(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void setupAnim(T entity, float f, float g, float h, float i, float j) {
    }

    public void copyHead(ModelPart model) {
        this.winter_hat.copyFrom(model);
    }

    public static Model getHatModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.getInstance().getEntityModels();
        WinterHatModel model = MODELS.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.WINTER_HAT.get()) {
                return new WinterHatModel(modelSet.bakeLayer(LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead);
        }
        return model;
    }
}

