/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.core.entity.ReindeerEntity;
import net.satisfy.alpinewhispers.core.entity.animation.ReindeerAnimation;
import org.jetbrains.annotations.NotNull;

public class ReindeerModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(AlpineWhispers.identifier("reindeer"), "main");
    private final ModelPart reindeer;
    private final ModelPart torso;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart bags;
    private boolean baby;

    public ReindeerModel(ModelPart root) {
        ModelPart reindeerRoot;
        this.reindeer = reindeerRoot = root.getChild("reindeer");
        this.torso = reindeerRoot.getChild("torso");
        this.neck = this.torso.getChild("neck");
        this.head = this.neck.getChild("head");
        this.bags = this.torso.getChild("bags");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition reindeer = partdefinition.addOrReplaceChild("reindeer", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.9369f, (float)0.2883f));
        PartDefinition torso = reindeer.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -12.5f, -23.0f, 12.0f, 13.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.5631f, (float)9.7117f));
        PartDefinition bags = torso.addOrReplaceChild("bags", CubeListBuilder.create().texOffs(36, 64).addBox(-6.0f, -25.0f, 1.0f, 12.0f, 13.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)12.5f, (float)-10.0f));
        PartDefinition cube_r1 = bags.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(8, 60).addBox(-7.0f, -10.0f, -1.0f, 8.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-16.0f, (float)6.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r2 = bags.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(8, 60).addBox(-7.0f, -10.0f, -1.0f, 8.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-16.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition neck = torso.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(16, 39).addBox(-3.025f, -15.6056f, -2.5381f, 6.0f, 14.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(50, 11).addBox(-2.025f, -15.6056f, -6.5381f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.025f, (float)-4.5f, (float)-18.0f, (float)1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 39).addBox(-4.0f, -6.026f, -7.483f, 8.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(50, 0).addBox(-3.0f, -4.026f, -13.483f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.025f, (float)-12.3668f, (float)0.4279f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition ear_cube_r1 = head.addOrReplaceChild("ear_cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0143f, -3.3235f, -4.9132f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5143f, (float)-3.18f, (float)2.9301f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition ear_cube_r2 = head.addOrReplaceChild("ear_cube_r2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.856f, -3.3235f, -4.9132f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-5.4857f, (float)-2.18f, (float)2.9301f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition rightHorn = head.addOrReplaceChild("rightHorn", CubeListBuilder.create().texOffs(66, 12).mirror().addBox(1.6122f, -13.8565f, -3.9132f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(1, 58).addBox(1.6122f, -6.8565f, -7.9132f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 57).addBox(1.6122f, -10.8565f, -8.9132f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(42, 55).addBox(1.6122f, -13.8565f, -1.9132f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(18, 0).mirror().addBox(6.6122f, -20.8565f, -1.9132f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(1, 58).mirror().addBox(6.6122f, -20.8565f, 0.0868f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(3, 60).mirror().addBox(8.6122f, -20.8565f, 2.0868f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.6064f, (float)-1.9068f, (float)1.4171f, (float)0.0f, (float)0.0f, (float)-0.9163f));
        PartDefinition leftHorn = head.addOrReplaceChild("leftHorn", CubeListBuilder.create().texOffs(66, 12).addBox(-3.6122f, -13.8565f, -3.9132f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(1, 58).mirror().addBox(-3.6122f, -6.8565f, -7.9132f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 57).mirror().addBox(-3.6122f, -10.8565f, -8.9132f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(42, 55).mirror().addBox(-13.6122f, -13.8565f, -1.9132f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(18, 0).mirror().addBox(-8.6122f, -20.8565f, -1.9132f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(1, 58).addBox(-8.6122f, -20.8565f, 0.0868f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(3, 60).addBox(-10.6122f, -20.8565f, 2.0868f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6064f, (float)-1.9068f, (float)1.4171f, (float)0.0f, (float)0.0f, (float)0.9163f));
        PartDefinition tail = torso.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 12).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)3.0f));
        PartDefinition rightArm = reindeer.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 39).addBox(-2.0f, 0.75f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)3.3131f, (float)-9.2883f));
        PartDefinition leftArm = reindeer.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 39).mirror().addBox(-2.0f, 0.75f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.5f, (float)3.3131f, (float)-9.2883f));
        PartDefinition rightLeg = reindeer.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(0, 6).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.5f, (float)2.0631f, (float)9.7117f));
        PartDefinition leftLeg = reindeer.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(0, 6).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.5f, (float)2.0631f, (float)9.7117f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)96, (int)96);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.reindeer.getAllParts().forEach(ModelPart::resetPose);
        ReindeerEntity reindeerEntity = (ReindeerEntity)entity;
        this.baby = reindeerEntity.isBaby();
        this.bags.visible = reindeerEntity.hasChest();
        ModelPart rightHorn = this.head.getChild("rightHorn");
        ModelPart leftHorn = this.head.getChild("leftHorn");
        rightHorn.visible = !this.baby;
        leftHorn.visible = !this.baby;
        float clampedSwingAmount = Math.min(limbSwingAmount, 1.0f);
        if (reindeerEntity.deathAnimationState.isStarted()) {
            this.animate(reindeerEntity.deathAnimationState, ReindeerAnimation.death, ageInTicks, 1.0f);
        } else if (reindeerEntity.attackAnimationState.isStarted()) {
            this.animate(reindeerEntity.attackAnimationState, ReindeerAnimation.attack, ageInTicks, 1.0f);
        } else if (clampedSwingAmount > 0.01f) {
            this.animateWalk(ReindeerAnimation.walk, limbSwing, clampedSwingAmount, 2.0f, 2.5f);
        } else {
            this.animate(reindeerEntity.idleAnimationState, ReindeerAnimation.idle, ageInTicks, 1.0f);
        }
    }

    public ModelPart head() {
        return this.head;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, int alpha) {
        if (this.baby) {
            boolean visible = this.head.visible;
            this.head.visible = false;
            this.reindeer.render(poseStack, vertexConsumer, light, overlay, alpha);
            this.head.visible = visible;
            poseStack.pushPose();
            this.reindeer.translateAndRotate(poseStack);
            this.torso.translateAndRotate(poseStack);
            this.neck.translateAndRotate(poseStack);
            poseStack.translate(0.0f, 0.5f, -0.1f);
            poseStack.scale(1.85f, 1.85f, 1.85f);
            this.head.render(poseStack, vertexConsumer, light, overlay, alpha);
            poseStack.popPose();
            return;
        }
        this.reindeer.render(poseStack, vertexConsumer, light, overlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.reindeer;
    }
}

