/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.architectury.fluid.FluidStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.client.renderer.block.FluidRenderer;
import net.satisfy.alpinewhispers.client.renderer.model.BathtubModel;
import net.satisfy.alpinewhispers.core.block.BathtubBlock;
import net.satisfy.alpinewhispers.core.block.entity.BathtubBlockEntity;

public class BathtubRenderer
implements BlockEntityRenderer<BathtubBlockEntity> {
    private static final ResourceLocation TEXTURE = AlpineWhispers.identifier("textures/entity/bathtub.png");
    private final BathtubModel model;

    public BathtubRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new BathtubModel(context.bakeLayer(BathtubModel.LAYER_LOCATION));
    }

    public void render(BathtubBlockEntity be, float partial, PoseStack pose, MultiBufferSource buffers, int light, int overlay) {
        if (be.getBlockState().getValue(BathtubBlock.PART) != BedPart.HEAD) {
            return;
        }
        pose.pushPose();
        Direction f = (Direction)be.getBlockState().getValue((Property)BathtubBlock.FACING);
        switch (f) {
            case EAST: {
                pose.translate(-0.5, 1.5, 0.5);
                break;
            }
            case WEST: {
                pose.translate(1.5, 1.5, 0.5);
                break;
            }
            case NORTH: {
                pose.translate(0.5, 1.5, 1.5);
                break;
            }
            case SOUTH: {
                pose.translate(0.5, 1.5, -0.5);
            }
        }
        pose.mulPose(Axis.YN.rotationDegrees(f.toYRot()));
        pose.mulPose(Axis.XP.rotationDegrees(180.0f));
        VertexConsumer vc = buffers.getBuffer(this.model.renderType(TEXTURE));
        this.model.renderToBuffer(pose, vc, light, OverlayTexture.NO_OVERLAY, -1);
        pose.popPose();
        float ratio = be.getFillRatio(partial);
        if (ratio <= 0.0f) {
            return;
        }
        float base = 0.475f;
        float height = 0.46f;
        float eps = 0.0015f;
        float yMax = base + height * ratio - eps;
        float xMin = 0.125f + eps;
        float xMax = 0.875f - eps;
        float zMin = -0.5625f + eps;
        float zMax = 1.21875f - eps;
        pose.pushPose();
        switch (f) {
            case EAST: {
                pose.translate(0.2, 0.0, 0.5);
                break;
            }
            case WEST: {
                pose.translate(0.8, 0.0, 0.5);
                break;
            }
            case NORTH: {
                pose.translate(0.5, 0.0, 0.8);
                break;
            }
            case SOUTH: {
                pose.translate(0.5, 0.0, 0.2);
            }
        }
        pose.mulPose(Axis.YN.rotationDegrees(f.toYRot()));
        pose.translate(-0.5, 0.0, -0.5);
        FluidRenderer.renderFluidBox(FluidStack.create((Fluid)Fluids.WATER, (long)100L), xMin, base + eps, zMin, xMax, yMax, zMax, buffers, pose, light, false, be.getLevel(), be.getBlockPos());
        pose.popPose();
    }
}

