/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.alpinewhispers.core.block.WardrobeBlock;
import net.satisfy.alpinewhispers.core.block.entity.WardrobeBlockEntity;
import org.jetbrains.annotations.NotNull;

public class WardrobeRenderer
implements BlockEntityRenderer<WardrobeBlockEntity>,
RenderLayerParent<ArmorStand, HumanoidModel<ArmorStand>> {
    private final HumanoidModel<ArmorStand> baseModel;
    private final HumanoidArmorLayer<ArmorStand, HumanoidModel<ArmorStand>, HumanoidModel<ArmorStand>> armorLayer;
    private ArmorStand dummy;
    public static float CHEST_TX = -0.2f;
    public static float CHEST_TY = 1.2f;
    public static float CHEST_TZ = 0.0f;
    public static float CHEST_YAW = 90.0f;
    public static float CHEST_PITCH = 0.0f;
    public static float CHEST_ROLL = 0.0f;
    public static float CHEST_SCALE = 1.7f;
    public static float LEGS_TX = 0.2f;
    public static float LEGS_TY = 1.6f;
    public static float LEGS_TZ = 0.0f;
    public static float LEGS_YAW = 90.0f;
    public static float LEGS_PITCH = 0.0f;
    public static float LEGS_ROLL = 0.0f;
    public static float LEGS_SCALE = 1.7f;
    public static float FEET_TX = 0.2f;
    public static float FEET_TY = 1.4f;
    public static float FEET_TZ = 0.0f;
    public static float FEET_YAW = 45.0f;
    public static float FEET_PITCH = 0.0f;
    public static float FEET_ROLL = 0.0f;
    public static float FEET_SCALE = 1.7f;

    public WardrobeRenderer(BlockEntityRendererProvider.Context context) {
        this.baseModel = new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER));
        this.armorLayer = new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), Minecraft.getInstance().getModelManager());
    }

    public void render(WardrobeBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (be.getLevel() == null) {
            return;
        }
        if (be.getBlockState().getValue(WardrobeBlock.HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (this.dummy == null || this.dummy.level() != be.getLevel()) {
            this.dummy = new ArmorStand(EntityType.ARMOR_STAND, be.getLevel());
            this.dummy.setNoBasePlate(true);
            this.dummy.setInvisible(true);
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 1.6, 0.5);
        switch ((Direction)be.getBlockState().getValue((Property)WardrobeBlock.FACING)) {
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            }
        }
        this.renderArmorPiece(poseStack, buffer, packedLight, be.getItem(1), EquipmentSlot.CHEST, CHEST_TX, CHEST_TY, CHEST_TZ, CHEST_YAW, CHEST_PITCH, CHEST_ROLL, CHEST_SCALE, partialTicks);
        this.renderArmorPiece(poseStack, buffer, packedLight, be.getItem(2), EquipmentSlot.LEGS, LEGS_TX, LEGS_TY, LEGS_TZ, LEGS_YAW, LEGS_PITCH, LEGS_ROLL, LEGS_SCALE, partialTicks);
        this.renderArmorPiece(poseStack, buffer, packedLight, be.getItem(3), EquipmentSlot.FEET, FEET_TX, FEET_TY, FEET_TZ, FEET_YAW, FEET_PITCH, FEET_ROLL, FEET_SCALE, partialTicks);
        poseStack.popPose();
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemStack stack, EquipmentSlot slot, float tx, float ty, float tz, float yaw, float pitch, float roll, float scale, float partialTicks) {
        if (stack.isEmpty()) {
            return;
        }
        ArmorStand partDummy = new ArmorStand(EntityType.ARMOR_STAND, this.dummy.level());
        partDummy.setNoBasePlate(true);
        partDummy.setInvisible(true);
        partDummy.setItemSlot(slot, stack);
        poseStack.pushPose();
        poseStack.translate(tx, ty, tz);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZP.rotationDegrees(roll));
        poseStack.scale(scale, -scale, -scale);
        if (slot == EquipmentSlot.LEGS) {
            this.baseModel.body.visible = false;
            this.baseModel.rightLeg.visible = true;
            this.baseModel.leftLeg.visible = true;
        } else if (slot == EquipmentSlot.CHEST) {
            this.baseModel.body.visible = true;
            this.baseModel.rightArm.visible = true;
            this.baseModel.leftArm.visible = true;
        } else if (slot == EquipmentSlot.FEET) {
            this.baseModel.rightLeg.visible = true;
            this.baseModel.leftLeg.visible = true;
        } else {
            this.baseModel.setAllVisible(false);
        }
        this.armorLayer.render(poseStack, buffer, packedLight, (LivingEntity)partDummy, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }

    @NotNull
    public HumanoidModel<ArmorStand> getModel() {
        return this.baseModel;
    }

    @NotNull
    public ResourceLocation getTextureLocation(ArmorStand entity) {
        return ResourceLocation.withDefaultNamespace((String)"textures/entity/armorstand/wood.png");
    }
}

