/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.client.model.entity.AlpineSheepModel;
import net.satisfy.alpinewhispers.core.entity.AlpineSheepEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AlpineSheepRenderer
extends MobRenderer<AlpineSheepEntity, AlpineSheepModel<AlpineSheepEntity>> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{AlpineWhispers.identifier("textures/entity/alpine_sheep_0.png"), AlpineWhispers.identifier("textures/entity/alpine_sheep_1.png"), AlpineWhispers.identifier("textures/entity/alpine_sheep_2.png")};

    public AlpineSheepRenderer(EntityRendererProvider.Context context) {
        super(context, new AlpineSheepModel(context.bakeLayer(AlpineSheepModel.LAYER_LOCATION)), 0.7f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(AlpineSheepEntity entity) {
        int index = Math.floorMod(entity.getUUID().hashCode(), TEXTURES.length);
        return TEXTURES[index];
    }

    public void render(AlpineSheepEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        if (entity.isBaby()) {
            stack.scale(0.4f, 0.4f, 0.4f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, stack, buffer, packedLight);
    }
}

