/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.block.entity.FireplaceCorniceBlockEntity;
import org.jetbrains.annotations.NotNull;

public class FireplaceCorniceBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.create((String)"right");
    public static final BooleanProperty APPLIED = BooleanProperty.create((String)"applied");

    public FireplaceCorniceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, TOP, BOTTOM, LEFT, RIGHT, APPLIED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        boolean water = context.getLevel().getFluidState(pos).getType() == Fluids.WATER;
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false));
        return FireplaceCorniceBlock.updateConnections(state, (BlockGetter)context.getLevel(), pos);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return FireplaceCorniceBlock.updateConnections(state, (BlockGetter)level, pos);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FireplaceCorniceBlockEntity(pos, state);
    }

    private static boolean canAccept(BlockState state) {
        if (state == null || state.isAir()) {
            return false;
        }
        if (state.getBlock() instanceof EntityBlock) {
            return false;
        }
        if (state.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        return Block.isShapeFullBlock((VoxelShape)state.getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO));
    }

    private static boolean isConnected(Direction facing, BlockState neighbor) {
        if (!(neighbor.getBlock() instanceof FireplaceCorniceBlock)) {
            return false;
        }
        return neighbor.getValue((Property)FACING) == facing;
    }

    private static BlockState updateConnections(BlockState state, BlockGetter level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean top = true;
        boolean bottom = true;
        boolean left = true;
        boolean right = true;
        BlockState upState = level.getBlockState(pos.above());
        BlockState downState = level.getBlockState(pos.below());
        if (FireplaceCorniceBlock.isConnected(facing, upState)) {
            top = false;
        }
        if (FireplaceCorniceBlock.isConnected(facing, downState)) {
            bottom = false;
        }
        if (facing == Direction.SOUTH) {
            BlockState westState = level.getBlockState(pos.west());
            BlockState eastState = level.getBlockState(pos.east());
            if (FireplaceCorniceBlock.isConnected(facing, westState)) {
                left = false;
            }
            if (FireplaceCorniceBlock.isConnected(facing, eastState)) {
                right = false;
            }
        } else if (facing == Direction.NORTH) {
            BlockState eastState = level.getBlockState(pos.east());
            BlockState westState = level.getBlockState(pos.west());
            if (FireplaceCorniceBlock.isConnected(facing, eastState)) {
                left = false;
            }
            if (FireplaceCorniceBlock.isConnected(facing, westState)) {
                right = false;
            }
        } else if (facing == Direction.EAST) {
            BlockState southState = level.getBlockState(pos.south());
            BlockState northState = level.getBlockState(pos.north());
            if (FireplaceCorniceBlock.isConnected(facing, southState)) {
                left = false;
            }
            if (FireplaceCorniceBlock.isConnected(facing, northState)) {
                right = false;
            }
        } else if (facing == Direction.WEST) {
            BlockState northState = level.getBlockState(pos.north());
            BlockState southState = level.getBlockState(pos.south());
            if (FireplaceCorniceBlock.isConnected(facing, northState)) {
                left = false;
            }
            if (FireplaceCorniceBlock.isConnected(facing, southState)) {
                right = false;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(left))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        if (item instanceof PickaxeItem) {
            if (!((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FireplaceCorniceBlockEntity) {
                FireplaceCorniceBlockEntity fireplaceEntity = (FireplaceCorniceBlockEntity)blockEntity;
                BlockState mimic = fireplaceEntity.getMimicState();
                if (mimic != null && !mimic.isAir()) {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)mimic.getBlock()));
                }
                BlockState newState = (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, newState, 3);
                fireplaceEntity.setMimicState(null);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendBlockUpdated(pos, state, newState, 3);
                    serverLevel.levelEvent(2001, pos, Block.getId((BlockState)(mimic == null ? Blocks.AIR.defaultBlockState() : mimic)));
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!(item instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState mimic = blockItem.getBlock().defaultBlockState();
        if (!FireplaceCorniceBlock.canAccept(mimic)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FireplaceCorniceBlockEntity) {
            FireplaceCorniceBlockEntity fireplaceEntity = (FireplaceCorniceBlockEntity)blockEntity;
            BlockState newState = (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(true));
            fireplaceEntity.setMimicState(mimic);
            level.setBlock(pos, newState, 3);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendBlockUpdated(pos, state, newState, 3);
                serverLevel.levelEvent(2001, pos, Block.getId((BlockState)mimic));
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.fireplace_cornice.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.fireplace_cornice.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        FireplaceCorniceBlockEntity fireplaceEntity;
        BlockState mimic;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FireplaceCorniceBlockEntity && (mimic = (fireplaceEntity = (FireplaceCorniceBlockEntity)blockEntity).getMimicState()) != null && !mimic.isAir() && !player.isCreative()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)mimic.getBlock()));
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean top = (Boolean)state.getValue((Property)TOP);
        boolean bottom = (Boolean)state.getValue((Property)BOTTOM);
        boolean left = (Boolean)state.getValue((Property)LEFT);
        boolean right = (Boolean)state.getValue((Property)RIGHT);
        VoxelShape shape = Shapes.empty();
        if (facing == Direction.SOUTH) {
            if (left) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0));
            }
            if (right) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0));
            }
            if (top) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0));
            }
            if (bottom) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)2.0));
            }
        } else if (facing == Direction.NORTH) {
            if (left) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0));
            }
            if (right) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0));
            }
            if (top) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0));
            }
            if (bottom) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0, (double)15.0));
            }
        } else if (facing == Direction.EAST) {
            if (left) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0));
            }
            if (right) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0));
            }
            if (top) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)0.0, (double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0));
            }
            if (bottom) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0));
            }
        } else if (facing == Direction.WEST) {
            if (left) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0));
            }
            if (right) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0));
            }
            if (top) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)11.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
            }
            if (bottom) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)FireplaceCorniceBlock.box((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0));
            }
        }
        return shape;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }
}

