/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public interface FrostyBlockInterface {
    public static final BooleanProperty FROSTY = BooleanProperty.create((String)"frosty");

    default public ItemInteractionResult handleFrostyUse(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!blockState.hasProperty((Property)FROSTY)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (itemStack.is(Items.SNOWBALL)) {
            BlockState newState;
            if (!level.isClientSide && (newState = FrostyBlockInterface.getIncreasedFrostyState(blockState, level, blockPos)) != blockState) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public void handleFrostyProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        if (level.isClientSide) {
            return;
        }
        if (!(projectile instanceof Snowball)) {
            return;
        }
        if (!blockState.hasProperty((Property)FROSTY)) {
            return;
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        FrostyBlockInterface.getIncreasedFrostyState(blockState, level, blockPos);
    }

    private static IntegerProperty getStageProperty(BlockState blockState) {
        for (Property property : blockState.getProperties()) {
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty integerProperty = (IntegerProperty)property;
            if (!property.getName().equals("stage")) continue;
            return integerProperty;
        }
        return null;
    }

    private static BlockState getIncreasedFrostyState(BlockState blockState, Level level, BlockPos blockPos) {
        int maxStage;
        int currentStage;
        IntegerProperty stageProperty;
        BlockState newState = blockState;
        boolean changed = false;
        if (!((Boolean)blockState.getValue((Property)FROSTY)).booleanValue()) {
            newState = (BlockState)newState.setValue((Property)FROSTY, (Comparable)Boolean.valueOf(true));
            changed = true;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double centerX = (double)blockPos.getX() + 0.5;
                double centerY = (double)blockPos.getY() + 0.5;
                double centerZ = (double)blockPos.getZ() + 0.5;
                BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState());
                serverLevel.sendParticles((ParticleOptions)particleOption, centerX, centerY, centerZ, 8, 0.25, 0.25, 0.25, 0.02);
            }
        }
        if ((stageProperty = FrostyBlockInterface.getStageProperty(blockState)) != null && (currentStage = ((Integer)blockState.getValue((Property)stageProperty)).intValue()) < (maxStage = ((Integer)Collections.max(stageProperty.getPossibleValues())).intValue())) {
            newState = (BlockState)newState.setValue((Property)stageProperty, (Comparable)Integer.valueOf(currentStage + 1));
            changed = true;
        }
        if (changed) {
            level.setBlock(blockPos, newState, 3);
        }
        return newState;
    }
}

