/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.block.entity.PrivyBlockEntity;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class PrivyBlock
extends BaseEntityBlock {
    public static final MapCodec<PrivyBlock> CODEC = PrivyBlock.simpleCodec(PrivyBlock::new);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty SMELLY = BooleanProperty.create((String)"smelly");
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.125, (double)0.8125, (double)0.4375, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.375, (double)0.0625, (double)0.875, (double)0.5, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.375, (double)0.5625, (double)0.875, (double)0.5, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.375, (double)0.0625, (double)0.375, (double)0.5, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.75, (double)0.875, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.375, (double)0.75, (double)0.9375, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public PrivyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SMELLY, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public MapCodec<PrivyBlock> codec() {
        return CODEC;
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SMELLY});
    }

    @NotNull
    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)FACING)));
    }

    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && entity instanceof ItemEntity) {
            PrivyBlockEntity privy;
            ItemEntity itemEntity = (ItemEntity)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof PrivyBlockEntity && (privy = (PrivyBlockEntity)blockEntity).absorb(itemEntity.getItem())) {
                itemEntity.discard();
            }
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isSecondaryUseActive()) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof PrivyBlockEntity) {
                PrivyBlockEntity privy = (PrivyBlockEntity)blockEntity;
                privy.releaseAll((ServerLevel)level, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        ItemInteractionResult result = GeneralUtil.onUse(level, player, InteractionHand.MAIN_HAND, hit, -0.3);
        return result.consumesAction() ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.PASS;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack one;
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof PrivyBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        PrivyBlockEntity privy = (PrivyBlockEntity)be;
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!stack.has(DataComponents.FOOD)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(Items.ROTTEN_FLESH) || stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean absorbed = false;
        int tries = stack.getCount();
        for (int i = 0; i < tries && privy.absorb(one = stack.copyWithCount(1)); ++i) {
            absorbed = true;
            if (player.isCreative()) break;
            stack.shrink(1);
        }
        if (absorbed) {
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!blockState.is(newState.getBlock())) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof PrivyBlockEntity) {
                PrivyBlockEntity privy = (PrivyBlockEntity)blockEntity;
                privy.dropAll((ServerLevel)level, pos);
            }
            super.onRemove(blockState, level, pos, newState, moved);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        double[] rings;
        if (!level.isClientSide) {
            return;
        }
        if (!((Boolean)blockState.getValue((Property)SMELLY)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        double centerX = (double)pos.getX() + 0.5;
        double centerZ = (double)pos.getZ() + 0.5;
        double centerY = (double)pos.getY() + 1.02;
        switch (facing) {
            case NORTH: {
                centerZ = (double)pos.getZ() + 0.62;
                break;
            }
            case SOUTH: {
                centerZ = (double)pos.getZ() + 0.38;
                break;
            }
            case WEST: {
                centerX = (double)pos.getX() + 0.62;
                break;
            }
            case EAST: {
                centerX = (double)pos.getX() + 0.38;
            }
        }
        DustParticleOptions fly = new DustParticleOptions(new Vector3f(0.05f, 0.06f, 0.05f), 0.075f);
        long time = level.getGameTime();
        double base = (double)time * 0.07;
        for (double radius : rings = new double[]{0.14, 0.22, 0.3}) {
            int count = 6;
            for (int i = 0; i < count; ++i) {
                double angle = base + (double)i * (Math.PI * 2 / (double)count);
                double x = centerX + Math.cos(angle) * radius + (random.nextDouble() - 0.5) * 0.02;
                double z = centerZ + Math.sin(angle) * radius + (random.nextDouble() - 0.5) * 0.02;
                double y = centerY + Math.sin((angle + radius) * 3.0) * 0.06 + (random.nextDouble() - 0.5) * 0.02;
                double speedX = -Math.sin(angle) * 0.012 + (random.nextDouble() - 0.5) * 0.002;
                double speedZ = Math.cos(angle) * 0.012 + (random.nextDouble() - 0.5) * 0.002;
                double speedY = 0.01 + random.nextDouble() * 0.01;
                level.addParticle((ParticleOptions)fly, x, y, z, speedX, speedY, speedZ);
            }
        }
        int wanderers = 10 + random.nextInt(6);
        for (int j = 0; j < wanderers; ++j) {
            double radius = 0.34 * Math.sqrt(random.nextDouble());
            double angle = random.nextDouble() * Math.PI * 2.0 + base * 0.5;
            double x = centerX + Math.cos(angle) * radius + (random.nextDouble() - 0.5) * 0.02;
            double z = centerZ + Math.sin(angle) * radius + (random.nextDouble() - 0.5) * 0.02;
            double y = (double)pos.getY() + 0.72 + random.nextDouble() * 0.44;
            double speedX = (random.nextDouble() - 0.5) * 0.012;
            double speedZ = (random.nextDouble() - 0.5) * 0.012;
            double speedY = 0.008 + random.nextDouble() * 0.012;
            level.addParticle((ParticleOptions)fly, x, y, z, speedX, speedY, speedZ);
        }
        int interval = 6;
        if ((time + pos.asLong()) % (long)interval == 0L) {
            SoundEvent[] beeBuzzSounds = new SoundEvent[]{SoundEvents.BEE_LOOP, SoundEvents.BEE_LOOP_AGGRESSIVE, SoundEvents.BEE_POLLINATE};
            int layers = 2 + random.nextInt(2);
            for (int i = 0; i < layers; ++i) {
                SoundEvent buzzSound = beeBuzzSounds[(i + (int)(time % (long)beeBuzzSounds.length)) % beeBuzzSounds.length];
                float volume = 0.05f + random.nextFloat() * 0.05f;
                float pitch = 1.8f + random.nextFloat() * 0.6f;
                double offsetX = (random.nextDouble() - 0.5) * 0.2;
                double offsetZ = (random.nextDouble() - 0.5) * 0.2;
                level.playLocalSound(centerX + offsetX, centerY, centerZ + offsetZ, buzzSound, SoundSource.AMBIENT, volume, pitch, false);
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new PrivyBlockEntity(pos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide ? null : PrivyBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.PRIVY_BLOCK_ENTITY.get()), (level1, pos, blockState1, blockEntity) -> PrivyBlockEntity.serverTick(level1, pos, blockEntity));
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PrivyBlockEntity) {
            PrivyBlockEntity privy = (PrivyBlockEntity)blockEntity;
            return privy.redstoneLevel();
        }
        return 0;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof PrivyBlockEntity) {
            PrivyBlockEntity privy = (PrivyBlockEntity)blockEntity;
            privy.dropAll((ServerLevel)level, pos);
        }
        super.playerWillDestroy(level, pos, blockState, player);
        return blockState;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.privy.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.privy.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

