/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SnowyDoublePlantBlock
extends DoublePlantBlock {
    public static final MapCodec<SnowyDoublePlantBlock> CODEC = SnowyDoublePlantBlock.simpleCodec(SnowyDoublePlantBlock::new);

    public SnowyDoublePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public MapCodec<? extends DoublePlantBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (!level.isClientSide) {
            return;
        }
        if (blockState.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            return;
        }
        if (!level.getBlockState(blockPos.below(2)).isAir()) {
            return;
        }
        long t = level.getDayTime() % 24000L;
        int chance = 0;
        if (t < 4000L) {
            chance = 200;
        } else if (t < 8000L) {
            chance = 120;
        } else if (t < 12000L) {
            chance = 80;
        }
        if (chance > 0 && randomSource.nextInt(chance) == 0) {
            double x = (double)blockPos.getX() + randomSource.nextDouble();
            double y = (double)blockPos.getY() + 0.9;
            double z = (double)blockPos.getZ() + randomSource.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, 0.0, -0.01, 0.0);
        }
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter world, BlockPos pos) {
        return state.is(Blocks.SNOW) || state.is(Blocks.SNOW_BLOCK) || super.mayPlaceOn(state, world, pos);
    }
}

