/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.alpinewhispers.core.item.TreeBaublesItem;
import org.jetbrains.annotations.NotNull;

public class SnowyLeavesBlock
extends LeavesBlock {
    public static final MapCodec<SnowyLeavesBlock> CODEC = SnowyLeavesBlock.simpleCodec(SnowyLeavesBlock::new);
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;

    public SnowyLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public MapCodec<? extends LeavesBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SNOWY});
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (mainHand.getItem() instanceof TreeBaublesItem || offHand.getItem() instanceof TreeBaublesItem) {
            return InteractionResult.PASS;
        }
        if (!mainHand.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!((Boolean)state.getValue((Property)SNOWY)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide && !player.isShiftKeyDown()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)), 3);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 0.5;
                double z = (double)pos.getZ() + 0.5;
                serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), x, y, z, 8, 0.25, 0.25, 0.25, 0.15);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!stack.is(Items.SNOWBALL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide && !((Boolean)state.getValue((Property)SNOWY)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        int maxParticleCount;
        int spawnChance;
        super.animateTick(blockState, level, blockPos, randomSource);
        if (!level.isClientSide) {
            return;
        }
        if (!((Boolean)blockState.getValue((Property)SNOWY)).booleanValue()) {
            return;
        }
        if (!level.getBlockState(blockPos.below()).isAir()) {
            return;
        }
        long timeOfDay = level.getDayTime() % 24000L;
        if (timeOfDay < 4000L) {
            spawnChance = 40;
            maxParticleCount = 2;
        } else if (timeOfDay < 8000L) {
            spawnChance = 28;
            maxParticleCount = 3;
        } else if (timeOfDay < 12000L) {
            spawnChance = 22;
            maxParticleCount = 3;
        } else {
            spawnChance = 55;
            maxParticleCount = 2;
        }
        if (randomSource.nextInt(spawnChance) != 0) {
            return;
        }
        int particleCount = 1 + randomSource.nextInt(maxParticleCount);
        for (int index = 0; index < particleCount; ++index) {
            double particleX = (double)blockPos.getX() + 0.2 + randomSource.nextDouble() * 0.6;
            double particleY = (double)blockPos.getY() + 0.9;
            double particleZ = (double)blockPos.getZ() + 0.2 + randomSource.nextDouble() * 0.6;
            double velocityX = (randomSource.nextDouble() - 0.5) * 0.02;
            double velocityY = -0.04 - randomSource.nextDouble() * 0.02;
            double velocityZ = (randomSource.nextDouble() - 0.5) * 0.02;
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.snowy_leaves.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.snowy_leaves.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

