/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.block.FairyLightsBlock;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class WallWreathBlock
extends FairyLightsBlock {
    public static final MapCodec<WallWreathBlock> CODEC = WallWreathBlock.simpleCodec(WallWreathBlock::new);
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES;

    public WallWreathBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public MapCodec<WallWreathBlock> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }

    private static VoxelShape createShape(Direction direction) {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.75, (double)0.875, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.375, (double)0.75, (double)0.625, (double)0.625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.625, (double)0.6875, (double)0.5625, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        return GeneralUtil.rotateShape(Direction.NORTH, direction, shape);
    }

    static {
        EnumMap<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            shapes.put(direction, WallWreathBlock.createShape(direction));
        }
        BOUNDING_SHAPES = Collections.unmodifiableMap(shapes);
    }
}

