/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block.entity;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.alpinewhispers.core.block.PrivyBlock;
import net.satisfy.alpinewhispers.core.entity.ChairEntity;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class PrivyBlockEntity
extends BlockEntity {
    private final SimpleContainer inventory = new SimpleContainer(9);
    private final Deque<Pending> queue = new ArrayDeque<Pending>();
    private final Map<UUID, Integer> sitTicks = new HashMap<UUID, Integer>();
    private final Random random = new Random();
    private boolean lastSmelly = false;
    private int smellyCooldown = 0;

    public PrivyBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)EntityTypeRegistry.PRIVY_BLOCK_ENTITY.get(), pos, blockState);
        this.lastSmelly = blockState.hasProperty((Property)PrivyBlock.SMELLY) && (Boolean)blockState.getValue((Property)PrivyBlock.SMELLY) != false;
    }

    public static void serverTick(Level level, BlockPos pos, PrivyBlockEntity blockEntity) {
        blockEntity.tickSit((ServerLevel)level, pos);
        blockEntity.tickProcess((ServerLevel)level, pos);
        blockEntity.tickSmellyState((ServerLevel)level);
    }

    private void tickSit(ServerLevel level, BlockPos pos) {
        Object e;
        Player seated = null;
        ChairEntity chair = GeneralUtil.getChairEntity((Level)level, pos);
        if (chair != null && !chair.getPassengers().isEmpty() && (e = chair.getPassengers().get(0)) instanceof Player) {
            Player player;
            seated = player = (Player)e;
        }
        if (seated == null) {
            this.sitTicks.clear();
            return;
        }
        UUID id = seated.getUUID();
        int accumulated = this.sitTicks.getOrDefault(id, 0);
        if (accumulated < 3000 && level.getGameTime() % 100L == 0L) {
            FoodData food = seated.getFoodData();
            food.setSaturation(Mth.clamp((float)(food.getSaturationLevel() - 0.5f), (float)0.0f, (float)20.0f));
            seated.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, 0, false, false, true));
            this.sitTicks.put(id, accumulated + 100);
        }
    }

    private void tickProcess(ServerLevel level, BlockPos pos) {
        if (!this.queue.isEmpty()) {
            Pending pending = this.queue.peek();
            if (pending.readyTime <= level.getGameTime()) {
                ItemStack outputStack = this.random.nextFloat() < 0.4f ? new ItemStack((ItemLike)Items.ROTTEN_FLESH) : new ItemStack((ItemLike)Items.BONE_MEAL);
                this.insertOrDrop(level, pos, outputStack);
                this.queue.poll();
                this.setChanged();
                this.sync();
            }
        }
    }

    private void tickSmellyState(ServerLevel level) {
        if (this.smellyCooldown > 0) {
            --this.smellyCooldown;
            return;
        }
        boolean current = this.hasSmelly();
        BlockState blockState = this.getBlockState();
        if (blockState.hasProperty((Property)PrivyBlock.SMELLY) && current != this.lastSmelly) {
            level.setBlock(this.worldPosition, (BlockState)blockState.setValue((Property)PrivyBlock.SMELLY, (Comparable)Boolean.valueOf(current)), 6);
            this.lastSmelly = current;
            this.smellyCooldown = 5;
        }
    }

    public boolean absorb(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        int count = itemStack.getCount();
        for (int i = 0; i < count; ++i) {
            assert (this.level != null);
            this.queue.add(new Pending(this.level.getGameTime() + 600L));
        }
        this.setChanged();
        this.sync();
        return true;
    }

    private void insertOrDrop(ServerLevel level, BlockPos pos, ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack currentStack = this.inventory.getItem(i);
            if (currentStack.isEmpty()) {
                this.inventory.setItem(i, itemStack);
                this.setChanged();
                this.sync();
                return;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)itemStack) || currentStack.getCount() >= currentStack.getMaxStackSize()) continue;
            int can = Math.min(itemStack.getCount(), currentStack.getMaxStackSize() - currentStack.getCount());
            currentStack.grow(can);
            itemStack.shrink(can);
            if (!itemStack.isEmpty()) continue;
            this.setChanged();
            this.sync();
            return;
        }
        GeneralUtil.popResourceFromFace((Level)level, pos, Direction.UP, itemStack);
    }

    public void releaseAll(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty()) continue;
            GeneralUtil.popResourceFromFace((Level)level, pos, Direction.UP, stack.copy());
            this.inventory.setItem(i, ItemStack.EMPTY);
        }
        this.setChanged();
        this.sync();
    }

    public void dropAll(ServerLevel level, BlockPos pos) {
        this.releaseAll(level, pos);
        this.queue.clear();
        this.setChanged();
        this.sync();
    }

    public int redstoneLevel() {
        int filled = 0;
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            if (this.inventory.getItem(i).isEmpty()) continue;
            ++filled;
        }
        return Mth.clamp((int)((int)Math.ceil((double)filled / 9.0 * 15.0)), (int)0, (int)15);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag items = new ListTag();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty()) continue;
            CompoundTag t = new CompoundTag();
            t.putByte("Slot", (byte)i);
            stack.save(provider, (Tag)t);
            items.add((Object)t);
        }
        tag.put("Items", (Tag)items);
        ListTag q = new ListTag();
        for (Pending pending : this.queue) {
            CompoundTag t = new CompoundTag();
            t.putLong("Ready", pending.readyTime);
            q.add((Object)t);
        }
        tag.put("Queue", (Tag)q);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.clearContent();
        ListTag items = tag.getList("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag t = items.getCompound(i);
            if (!t.contains("id", 8)) continue;
            int slot = t.getByte("Slot") & 0xFF;
            this.inventory.setItem(slot, ItemStack.parse((HolderLookup.Provider)provider, (Tag)t).orElse(ItemStack.EMPTY));
        }
        this.queue.clear();
        ListTag q = tag.getList("Queue", 10);
        for (int i = 0; i < q.size(); ++i) {
            CompoundTag t = q.getCompound(i);
            this.queue.add(new Pending(t.getLong("Ready")));
        }
        this.lastSmelly = this.getBlockState().hasProperty((Property)PrivyBlock.SMELLY) && (Boolean)this.getBlockState().getValue((Property)PrivyBlock.SMELLY) != false;
        this.smellyCooldown = 0;
    }

    public boolean hasSmelly() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack s = this.inventory.getItem(i);
            if (s.isEmpty() || !s.is(Items.BONE_MEAL) && !s.is(Items.ROTTEN_FLESH)) continue;
            return true;
        }
        return false;
    }

    private void sync() {
        if (this.level != null) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private record Pending(long readyTime) {
    }
}

