/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.entity;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlpineSheepEntity
extends Animal
implements Shearable,
ItemSteerable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(AlpineSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState eatAnimationState = new AnimationState();
    public final AnimationState shakeAnimationState = new AnimationState();
    private int eatAnimationTick;
    private int eatAnimationTimeout;
    private int shakeAnimationTick;
    private int boostTime;
    private int breadEffectTicks;
    private boolean breadEffectActive;
    private int breadFeedCooldownTicks;

    public AlpineSheepEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        AlpineSheepEatBlockGoal eatBlockGoal = new AlpineSheepEatBlockGoal((Mob)this);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)eatBlockGoal);
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private void setupAnimationStates() {
        if (!this.idleAnimationState.isStarted()) {
            this.idleAnimationState.start(this.tickCount);
        }
        if (this.eatAnimationTick > 0) {
            if (this.eatAnimationTimeout <= 0) {
                this.eatAnimationState.start(this.tickCount);
                this.eatAnimationTimeout = 48;
            } else {
                --this.eatAnimationTimeout;
            }
        } else {
            this.eatAnimationState.stop();
            this.eatAnimationTimeout = 0;
        }
        if (this.shakeAnimationTick > 0) {
            if (!this.shakeAnimationState.isStarted()) {
                this.shakeAnimationState.start(this.tickCount);
            }
        } else {
            this.shakeAnimationState.stop();
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.updateBreadEffect();
            if (this.breadFeedCooldownTicks > 0) {
                --this.breadFeedCooldownTicks;
            }
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.eatAnimationTick > 0) {
            --this.eatAnimationTick;
            if (this.eatAnimationTick == 0) {
                this.eatAnimationState.stop();
            }
        }
        if (this.shakeAnimationTick > 0) {
            --this.shakeAnimationTick;
            if (this.shakeAnimationTick == 0) {
                this.shakeAnimationState.stop();
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHEARED, (Object)false);
    }

    protected void updateWalkAnimation(float movementAmount) {
        float value = this.getPose() == Pose.STANDING ? Math.min(movementAmount * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(value, 0.2f);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(SHEARED, (Object)sheared);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.MOVEMENT_SPEED, 0.23);
    }

    public void handleEntityEvent(byte event) {
        if (event == 10) {
            this.eatAnimationTick = 48;
        } else if (event == 11) {
            this.shakeAnimationTick = 55;
        } else if (event == 12) {
            if (this.level().isClientSide()) {
                this.shakeAnimationTick = 55;
                for (int index = 0; index < 6; ++index) {
                    double offsetX = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
                    double offsetY = this.random.nextDouble() * (double)this.getBbHeight();
                    double offsetZ = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
                    this.level().addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent(event);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SHEEP_AMBIENT;
    }

    public SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SHEEP_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.SHEEP_DEATH;
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playSound(SoundEvents.SHEEP_STEP, 0.15f, 1.0f);
    }

    public float getVoicePitch() {
        return this.isBaby() ? 1.5f : 1.1f;
    }

    @Nullable
    public AlpineSheepEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AlpineSheepEntity)((EntityType)EntityTypeRegistry.ALPINE_SHEEP_ENTITY.get()).create((Level)serverLevel);
    }

    public void ate() {
        super.ate();
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)10);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.is(Items.BREAD)) {
            if (!this.level().isClientSide()) {
                if (this.breadFeedCooldownTicks > 0 || this.breadEffectActive) {
                    return InteractionResult.CONSUME;
                }
                this.level().playSound(null, (Entity)this, SoundEvents.CAMEL_EAT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                this.startBreadEffect();
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (itemStack.getItem() instanceof ShearsItem && this.readyForShearing()) {
            this.shear(SoundSource.PLAYERS);
            itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (!(this.level().isClientSide() || player.isSecondaryUseActive() || this.isBaby() || player.isShiftKeyDown())) {
            player.startRiding((Entity)this);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, interactionHand);
    }

    private void startBreadEffect() {
        this.breadEffectActive = true;
        this.breadEffectTicks = 0;
        this.breadFeedCooldownTicks = 80;
    }

    private void updateBreadEffect() {
        if (!this.breadEffectActive) {
            return;
        }
        ++this.breadEffectTicks;
        if (this.breadEffectTicks == 200) {
            this.level().broadcastEntityEvent((Entity)this, (byte)12);
        }
        if (this.breadEffectTicks >= 300) {
            this.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.0f);
            this.playSound(SoundEvents.SHEEP_HURT, 1.0f, 1.0f);
            this.breadEffectActive = false;
            this.breadEffectTicks = 0;
        }
    }

    public void shear(@NotNull SoundSource shearedSoundCategory) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int woolCount = 1 + this.random.nextInt(3);
        for (int index = 0; index < woolCount; ++index) {
            ItemEntity itemEntity = this.spawnAtLocation((ItemLike)ObjectRegistry.HOMESPUN_WOOL.get(), 1);
            if (itemEntity == null) continue;
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)11);
        }
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sheared", this.isSheared());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSheared(tag.getBoolean("Sheared"));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.WHEAT);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Player player;
        Entity firstPassenger = this.getFirstPassenger();
        if (firstPassenger instanceof Player && (player = (Player)firstPassenger).isHolding((Item)ObjectRegistry.BREAD_ON_A_STICK.get())) {
            return player;
        }
        return null;
    }

    public boolean boost() {
        if (this.boostTime > 0) {
            return false;
        }
        this.boostTime = 80;
        return true;
    }

    public void travel(@NotNull Vec3 travelVector) {
        LivingEntity controllingPassenger = this.getControllingPassenger();
        if (this.isAlive() && this.isVehicle() && controllingPassenger != null) {
            Player player;
            this.setYRot(controllingPassenger.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(controllingPassenger.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            float strafe = 0.0f;
            float forward = 1.0f;
            if (controllingPassenger instanceof Player && (player = (Player)controllingPassenger).isShiftKeyDown()) {
                forward = 0.0f;
            }
            double baseSpeed = this.getAttributeValue(Attributes.MOVEMENT_SPEED);
            float speed = (float)baseSpeed * 0.9f;
            if (this.boostTime > 0) {
                speed *= 1.5f;
                --this.boostTime;
            }
            this.setSpeed(speed);
            super.travel(new Vec3((double)strafe, travelVector.y, (double)forward));
        } else {
            super.travel(travelVector);
        }
    }

    public void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (!this.level().isClientSide() && passenger instanceof Player) {
            this.level().broadcastEntityEvent((Entity)this, (byte)11);
        }
    }

    public static class AlpineSheepEatBlockGoal
    extends Goal {
        private static final int EAT_ANIMATION_TICKS = 48;
        private final Mob mob;
        private final Level level;
        private int eatAnimationTick;

        public AlpineSheepEatBlockGoal(Mob mob) {
            this.mob = mob;
            this.level = mob.level();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            if (this.mob.getRandom().nextInt(this.mob.isBaby() ? 50 : 1000) != 0) {
                return false;
            }
            BlockPos blockPos = this.mob.blockPosition();
            BlockState stateAtFeet = this.level.getBlockState(blockPos);
            BlockState stateBelow = this.level.getBlockState(blockPos.below());
            if (this.isEdibleFoliage(stateAtFeet) || this.isEdibleTerrain(stateAtFeet)) {
                return true;
            }
            return this.isEdibleTerrain(stateBelow);
        }

        private boolean isEdibleFoliage(BlockState blockState) {
            return blockState.is(Blocks.SHORT_GRASS) || blockState.is((Block)ObjectRegistry.HOARFROST_GRASS.get()) || blockState.is((Block)ObjectRegistry.TALL_HOARFROST_GRASS.get());
        }

        private boolean isEdibleTerrain(BlockState blockState) {
            return blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.SNOW) || blockState.is(Blocks.SNOW_BLOCK) || blockState.is(Blocks.POWDER_SNOW) || blockState.is((Block)ObjectRegistry.FROZEN_DIRT.get());
        }

        public void start() {
            this.eatAnimationTick = this.adjustedTickDelay(48);
            this.level.broadcastEntityEvent((Entity)this.mob, (byte)10);
            this.mob.getNavigation().stop();
        }

        public void stop() {
            this.eatAnimationTick = 0;
        }

        public boolean canContinueToUse() {
            return this.eatAnimationTick > 0;
        }

        public void tick() {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (this.eatAnimationTick == this.adjustedTickDelay(4)) {
                BlockPos blockPos = this.mob.blockPosition();
                BlockState stateAtFeet = this.level.getBlockState(blockPos);
                if (this.isEdibleFoliage(stateAtFeet)) {
                    if (this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                        this.level.destroyBlock(blockPos, false);
                    }
                    this.mob.ate();
                } else {
                    BlockState targetState;
                    BlockPos targetPos;
                    if (this.isEdibleTerrain(stateAtFeet)) {
                        targetPos = blockPos;
                        targetState = stateAtFeet;
                    } else {
                        targetPos = blockPos.below();
                        targetState = this.level.getBlockState(targetPos);
                    }
                    if (this.isEdibleTerrain(targetState)) {
                        if (this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && targetState.is(Blocks.GRASS_BLOCK)) {
                            this.level.levelEvent(2001, targetPos, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                            this.level.setBlock(targetPos, Blocks.DIRT.defaultBlockState(), 2);
                        }
                        this.mob.ate();
                    }
                }
            }
        }
    }
}

