/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class ChairEntity
extends Entity {
    private BlockPos seatPos;
    private boolean seatPosInit;

    public ChairEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void setSeatPos(BlockPos pos) {
        this.seatPos = pos.immutable();
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Player p;
        BlockPos pos;
        if (passenger instanceof Player && (pos = GeneralUtil.getPreviousPlayerPosition(p = (Player)passenger, this)) != null) {
            this.discard();
            return new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        }
        this.discard();
        return super.getDismountLocationForPassenger(passenger);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        GeneralUtil.removeChairEntity(this.level(), this.seatPos != null ? this.seatPos : this.blockPosition());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("spx")) {
            int x = tag.getInt("spx");
            int y = tag.getInt("spy");
            int z = tag.getInt("spz");
            this.seatPos = new BlockPos(x, y, z);
            this.seatPosInit = true;
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        BlockPos p = this.seatPos != null ? this.seatPos : this.blockPosition();
        tag.putInt("spx", p.getX());
        tag.putInt("spy", p.getY());
        tag.putInt("spz", p.getZ());
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction move) {
        move.accept(passenger, this.getX(), this.getY(), this.getZ());
    }

    public boolean isControlledByLocalInstance() {
        return false;
    }

    private float computeYawFromBlock() {
        BlockPos p = this.seatPos != null ? this.seatPos : this.blockPosition();
        BlockState s = this.level().getBlockState(p);
        float yaw = this.getYRot();
        if (s.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            yaw = ((Direction)s.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot();
        } else if (s.hasProperty((Property)BlockStateProperties.FACING)) {
            yaw = ((Direction)s.getValue((Property)BlockStateProperties.FACING)).toYRot();
        } else {
            for (Property prop : s.getProperties()) {
                if (!prop.getName().equals("facing") || !(prop instanceof DirectionProperty)) continue;
                DirectionProperty dir = (DirectionProperty)prop;
                yaw = ((Direction)s.getValue((Property)dir)).toYRot();
                break;
            }
        }
        if (s.hasProperty((Property)BlockStateProperties.BED_PART) && ((BedPart)s.getValue((Property)BlockStateProperties.BED_PART)).toString().equals("head")) {
            yaw += 180.0f;
        } else {
            for (Property prop : s.getProperties()) {
                Comparable v;
                if (!prop.getName().equals("part") || !(v = s.getValue(prop)).toString().equals("head")) continue;
                yaw += 180.0f;
                break;
            }
        }
        return yaw;
    }

    public void onPassengerTurned(Entity passenger) {
        if (passenger instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)passenger;
            float yaw = this.getYRot();
            l.setYBodyRot(yaw);
            l.yBodyRotO = yaw;
        }
    }

    public void tick() {
        super.tick();
        if (!this.seatPosInit) {
            this.seatPos = this.blockPosition();
            this.seatPosInit = true;
        }
        float target = this.computeYawFromBlock();
        if (this.getYRot() != target) {
            this.setYRot(target);
            this.yRotO = target;
        }
        if (!this.getPassengers().isEmpty()) {
            for (Entity e : this.getPassengers()) {
                if (!(e instanceof Player)) continue;
                Player p = (Player)e;
                if (!this.level().isClientSide) {
                    p.setDeltaMovement(Vec3.ZERO);
                }
                float yaw = this.getYRot();
                p.setYBodyRot(yaw);
                p.yBodyRotO = yaw;
            }
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity server) {
        return new ClientboundAddEntityPacket((Entity)this, server);
    }
}

