/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.core.block.entity.BathtubBlockEntity;
import net.satisfy.alpinewhispers.core.block.entity.CabinetBlockEntity;
import net.satisfy.alpinewhispers.core.block.entity.FireplaceCorniceBlockEntity;
import net.satisfy.alpinewhispers.core.block.entity.PrivyBlockEntity;
import net.satisfy.alpinewhispers.core.block.entity.SmokeOvenEntity;
import net.satisfy.alpinewhispers.core.block.entity.TreeBaublesBlockEntity;
import net.satisfy.alpinewhispers.core.block.entity.WardrobeBlockEntity;
import net.satisfy.alpinewhispers.core.entity.AlpineSheepEntity;
import net.satisfy.alpinewhispers.core.entity.ChairEntity;
import net.satisfy.alpinewhispers.core.entity.ReindeerEntity;
import net.satisfy.alpinewhispers.core.registry.ObjectRegistry;

public class EntityTypeRegistry {
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"alpinewhispers", (ResourceKey)Registries.BLOCK_ENTITY_TYPE).getRegistrar();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"alpinewhispers", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.of(CabinetBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.AROLLA_PINE_CABINET.get(), (Block)ObjectRegistry.AROLLA_PINE_WALL_CABINET.get(), (Block)ObjectRegistry.AROLLA_PINE_DRESSER.get(), (Block)ObjectRegistry.AROLLA_PINE_COOKING_AISLE.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<SmokeOvenEntity>> SMOKER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("smoker", () -> BlockEntityType.Builder.of(SmokeOvenEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.AROLLA_PINE_SMOKER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<WardrobeBlockEntity>> WARDROBE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("wardrobe", () -> BlockEntityType.Builder.of(WardrobeBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.AROLLA_PINE_WARDROBE.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<BathtubBlockEntity>> BATHTUB_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("bathtub", () -> BlockEntityType.Builder.of(BathtubBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.AROLLA_PINE_BATHTUB.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<PrivyBlockEntity>> PRIVY_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("privy", () -> BlockEntityType.Builder.of(PrivyBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.AROLLA_PINE_PRIVY.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<FireplaceCorniceBlockEntity>> FIRE_PLACE_CORNICE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("fire_place_cornice", () -> BlockEntityType.Builder.of(FireplaceCorniceBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FIREPLACE_CORNICE.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<TreeBaublesBlockEntity>> TREE_BAUBLES_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("tree_baubles", () -> BlockEntityType.Builder.of(TreeBaublesBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TREE_BAUBLES.get()}).build(null));
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR_ENTITY = EntityTypeRegistry.registerEntityType("chair", () -> EntityType.Builder.of(ChairEntity::new, (MobCategory)MobCategory.MISC).sized(0.001f, 0.001f).build(AlpineWhispers.identifier("chair").toString()));
    public static final RegistrySupplier<EntityType<ReindeerEntity>> REINDEER_ENTITY = EntityTypeRegistry.registerEntityType("reindeer", () -> EntityType.Builder.of(ReindeerEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.1f, 1.6f).build(AlpineWhispers.identifier("reindeer").toString()));
    public static final RegistrySupplier<EntityType<AlpineSheepEntity>> ALPINE_SHEEP_ENTITY = EntityTypeRegistry.registerEntityType("alpine_sheep", () -> EntityType.Builder.of(AlpineSheepEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.8f, 1.1f).build(AlpineWhispers.identifier("alpine_sheep").toString()));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(AlpineWhispers.identifier(path), type);
    }

    public static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(AlpineWhispers.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        EntityAttributeRegistry.register(REINDEER_ENTITY, ReindeerEntity::createMobAttributes);
        EntityAttributeRegistry.register(ALPINE_SHEEP_ENTITY, AlpineSheepEntity::createMobAttributes);
    }
}

