/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.neoforge.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.alpinewhispers.core.block.FrostyBlockInterface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrushItem.class})
public abstract class BrushItemMixin {
    @Unique
    private static final int ALPINEWHISPERS_FROSTY_TICKS_REQUIRED = 30;

    @Shadow
    private HitResult calculateHitResult(Player player) {
        return null;
    }

    @Shadow
    public abstract int getUseDuration(ItemStack var1, LivingEntity var2);

    @Inject(method={"onUseTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;I)V"}, at={@At(value="HEAD")})
    private void alpinewhispers$frostyBrush(Level level, LivingEntity livingEntity, ItemStack itemStack, int remainingUseTicks, CallbackInfo callbackInfo) {
        BlockHitResult blockHitResult;
        block9: {
            block8: {
                if (!(livingEntity instanceof Player)) {
                    return;
                }
                Player player = (Player)livingEntity;
                HitResult hitResult = this.calculateHitResult(player);
                if (!(hitResult instanceof BlockHitResult)) break block8;
                blockHitResult = (BlockHitResult)hitResult;
                if (hitResult.getType() == HitResult.Type.BLOCK) break block9;
            }
            return;
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        BlockState blockState = level.getBlockState(blockPos);
        if (!blockState.hasProperty((Property)FrostyBlockInterface.FROSTY) || !((Boolean)blockState.getValue((Property)FrostyBlockInterface.FROSTY)).booleanValue()) {
            return;
        }
        int useDuration = this.getUseDuration(itemStack, livingEntity);
        int elapsedTicks = useDuration - remainingUseTicks + 1;
        if (elapsedTicks < 0) {
            return;
        }
        if (level.isClientSide) {
            double centerX = (double)blockPos.getX() + 0.5;
            double centerY = (double)blockPos.getY() + 0.7;
            double centerZ = (double)blockPos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, centerX, centerY, centerZ, 0.0, 0.02, 0.0);
            return;
        }
        if (elapsedTicks >= 30) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)FrostyBlockInterface.FROSTY, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

