/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockGoldPortal;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.ItemBuildKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockPortalKeyhole
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final BooleanProperty IS_BUILDING = BooleanProperty.create((String)"is_building");
    public static final String REG_NAME = "block_portal_keyhole";

    protected MapCodec<? extends BlockPortalKeyhole> codec() {
        throw new AssertionError((Object)"Implement block codec!");
    }

    public BlockPortalKeyhole() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.COW_BELL).strength(3.0f).explosionResistance(1200.0f).sound(SoundType.METAL));
        this.registerDefaultState(this.getMyCustomDefaultState());
    }

    public BlockState getMyCustomDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_BUILDING, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return null;
        }
        if (((Boolean)state.getValue((Property)IS_BUILDING)).booleanValue() && type == BlockRegistrar.BE_PORTAL_KEYHOLE.get()) {
            return type == BlockRegistrar.BE_PORTAL_KEYHOLE.get() ? TileEntityPortalKeyhole::tick : null;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        boolean hasPortalBlockBelow = worldIn.getBlockState(pos.below()).getBlock() == BlockRegistrar.BLOCK_GOLD_PORTAL.get();
        Direction enumfacing = (Direction)stateIn.getValue((Property)FACING);
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + rand.nextDouble() * 6.0 / 16.0;
        double d2 = (double)pos.getZ() + 0.5;
        double d4 = rand.nextDouble() * 0.6 - 0.3;
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue() && hasPortalBlockBelow) {
            if (rand.nextDouble() < 0.1 && DungeonConfig.playPortalSounds) {
                worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 1.0f, 2.5f, false);
            }
            if (DungeonConfig.showParticles) {
                switch (enumfacing) {
                    case WEST: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0 - 0.52, d1, d2 + d4, -1.0, 1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0 + 0.52, d1, d2 + d4, 1.0, 1.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0 + d4, d1, d2 - 0.52, 0.0, 1.0, -1.0);
                        break;
                    }
                    default: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0 + d4, d1, d2 + 0.52, 0.0, 1.0, 1.0);
                    }
                }
            }
        }
        if (((Boolean)stateIn.getValue((Property)IS_BUILDING)).booleanValue()) {
            if (DungeonConfig.playPortalSounds) {
                float randomPitch = worldIn.getRandom().nextFloat() * 2.0f;
                worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 0.7f, randomPitch, false);
            }
            if (DungeonConfig.showParticles) {
                switch (enumfacing) {
                    case WEST: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 - 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, 0.23);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 - 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, -0.23);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d4, d1 + 0.5, d2 - 0.12, -0.08, 0.0, 0.0);
                        break;
                    }
                    case EAST: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 + 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, 0.23);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 + 0.12, d1 + 1.5, d2 + d4, 0.0, 0.0, -0.23);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d4, d1 + 0.5, d2 - 0.12, 0.08, 0.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 + d4, d1 + 1.5, d2 - 0.12, 0.23, 0.0, 0.0);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 + d4, d1 + 1.5, d2 - 0.12, -0.23, 0.0, 0.0);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 - 0.12, d1 + 0.5, d2 + d4, 0.0, 0.0, -0.08);
                        break;
                    }
                    default: {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 + d4, d1 + 1.5, d2 + 0.12, 0.23, 0.0, 0.0);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0 + d4, d1 + 1.5, d2 + 0.12, -0.23, 0.0, 0.0);
                        worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 - 0.12, d1 + 0.5, d2 + d4, 0.0, 0.0, 0.08);
                    }
                }
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        TileEntityPortalKeyhole myEntity = (TileEntityPortalKeyhole)tileEntity;
        if (myEntity == null) {
            DimDungeons.logMessageError("dimdungeons: BlockEntity missing inside of BlockPortalKeyhole::useWithoutItem");
            return InteractionResult.PASS;
        }
        ItemStack insideItem = myEntity.getObjectInserted();
        if (insideItem.isEmpty()) {
            return InteractionResult.PASS;
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, insideItem);
        BlockPortalKeyhole.consequencesForRemovingIternalItem(myEntity, insideItem, worldIn, pos, state);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        ItemStack playerItem = player.getItemInHand(handIn);
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        TileEntityPortalKeyhole myEntity = (TileEntityPortalKeyhole)tileEntity;
        if (handIn != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (myEntity == null) {
            DimDungeons.logMessageError("dimdungeons: BlockEntity missing inside of BlockPortalKeyhole::useWithoutItem");
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (playerItem.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack insideItem = myEntity.getObjectInserted();
        if (!playerItem.isEmpty() && playerItem.getItem() instanceof BaseItemKey && BaseItemKey.hasLegacyData(playerItem)) {
            DimDungeons.logMessageInfo("DIMDUNGEONS: Fixing a legacy key.");
            BaseItemKey.convertLegacyData(playerItem);
        }
        if (!insideItem.isEmpty() && insideItem.getItem() instanceof BaseItemKey && BaseItemKey.hasLegacyData(insideItem)) {
            DimDungeons.logMessageInfo("DIMDUNGEONS: Fixing a legacy key.");
            BaseItemKey.convertLegacyData(insideItem);
        }
        if (insideItem.isEmpty()) {
            boolean is_building = false;
            myEntity.setContents(playerItem.copy());
            if (playerItem.getItem() instanceof ItemPortalKey && !worldIn.isClientSide && BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity)) {
                key = (ItemPortalKey)playerItem.getItem();
                long buildX = key.getDungeonTopLeftX(playerItem);
                long buildZ = key.getDungeonTopLeftZ(playerItem);
                long entranceX = buildX + 128L;
                long entranceZ = buildZ + 176L;
                DungeonGenData genData = DungeonGenData.Create().setKeyItem(playerItem).setDungeonType(key.getDungeonType(playerItem)).setTheme(key.getDungeonTheme(playerItem)).setReturnPoint(BlockPortalKeyhole.getReturnPoint(state, pos), DungeonUtils.serializeDimensionKey((ResourceKey<Level>)worldIn.dimension()));
                if (this.shouldBuildDungeon(playerItem)) {
                    if (!DungeonUtils.dungeonAlreadyExistsHere(worldIn, entranceX, entranceZ)) {
                        ItemPortalKey.setDungeonBuilt(playerItem);
                        myEntity.setContents(playerItem.copy());
                        DungeonPlacement.beginDesignAndBuild(DungeonUtils.getDungeonWorld(worldIn.getServer()), buildX, buildZ, genData);
                    }
                    is_building = true;
                } else {
                    is_building = true;
                }
            } else if (playerItem.getItem() instanceof ItemBuildKey && !worldIn.isClientSide && BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity)) {
                key = (ItemBuildKey)playerItem.getItem();
                long buildX = ((ItemBuildKey)key).getDungeonTopLeftX(playerItem);
                long buildZ = ((ItemBuildKey)key).getDungeonTopLeftZ(playerItem);
                DungeonGenData genData = DungeonGenData.Create().setKeyItem(playerItem).setReturnPoint(BlockPortalKeyhole.getReturnPoint(state, pos), DungeonUtils.serializeDimensionKey((ResourceKey<Level>)worldIn.dimension()));
                if (key.isActivated(playerItem) && !((ItemBuildKey)key).isPlotBuilt(playerItem) && !DungeonUtils.personalPortalAlreadyExistsHere(worldIn, buildX, buildZ)) {
                    DimDungeons.logMessageInfo("DIMENSIONAL DUNGEONS: building a new personal dimension.");
                    ItemPortalKey.setDungeonBuilt(playerItem);
                    myEntity.setContents(playerItem.copy());
                    DungeonUtils.buildSuperflatPersonalSpace(buildX, buildZ, player.getServer());
                }
                is_building = false;
                DungeonUtils.openPortalAfterBuild(worldIn, pos, genData, myEntity);
            }
            BlockState newBlockState = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).setValue((Property)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()))).setValue((Property)IS_BUILDING, (Comparable)Boolean.valueOf(is_building));
            worldIn.setBlockAndUpdate(pos, newBlockState);
            playerItem.shrink(1);
            worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 0.7f, 1.2f, false);
            return ItemInteractionResult.SUCCESS;
        }
        if (playerItem.isEmpty()) {
            player.setItemInHand(handIn, insideItem);
        } else if (!player.addItem(insideItem)) {
            player.drop(insideItem, false);
        }
        BlockPortalKeyhole.consequencesForRemovingIternalItem(myEntity, insideItem, worldIn, pos, state);
        return ItemInteractionResult.SUCCESS;
    }

    private static void consequencesForRemovingIternalItem(TileEntityPortalKeyhole myEntity, ItemStack insideItem, Level worldIn, BlockPos pos, BlockState state) {
        ItemPortalKey key;
        if (insideItem.getItem() instanceof ItemPortalKey && !worldIn.isClientSide && (key = (ItemPortalKey)insideItem.getItem()).getDungeonType(insideItem) == DungeonDesigner.DungeonType.TELEPORTER_HUB && key.getDungeonTheme(insideItem) != 0) {
            float entranceX = key.getWarpX(insideItem);
            float entranceZ = key.getWarpZ(insideItem);
            DungeonGenData genData = DungeonGenData.Create();
            genData.setDungeonType(DungeonDesigner.DungeonType.TELEPORTER_HUB);
            genData.setTheme(key.getDungeonTheme(insideItem));
            DungeonUtils.reprogramTeleporterHubDoorway(worldIn, (long)entranceX, (long)entranceZ, genData, Direction.NORTH, true);
        }
        myEntity.removeContents();
        worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.TRIPWIRE_CLICK_OFF, SoundSource.BLOCKS, 0.7f, 0.8f, false);
        BlockState newBlockState = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).setValue((Property)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()))).setValue((Property)IS_BUILDING, (Comparable)Boolean.valueOf(false));
        worldIn.setBlock(pos, newBlockState, 3);
    }

    public static void addGoldenPortalBlock(Level worldIn, BlockPos pos, ItemStack keyStack, Direction.Axis axis) {
        BaseItemKey key;
        worldIn.setBlockAndUpdate(pos, (BlockState)((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState().setValue(BlockGoldPortal.AXIS, (Comparable)axis));
        TileEntityGoldPortal te = (TileEntityGoldPortal)worldIn.getBlockEntity(pos);
        if (te != null && te instanceof TileEntityGoldPortal && (key = (BaseItemKey)keyStack.getItem()) != null) {
            if (key instanceof ItemPortalKey) {
                ItemPortalKey keyItem = (ItemPortalKey)keyStack.getItem();
                Direction enterFacing = Direction.NORTH;
                if (keyItem.getDungeonType(keyStack) == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                    enterFacing = BlockPortalKeyhole.getTeleporterHubEntranceDirection(keyItem.getDungeonTheme(keyStack));
                }
                te.setDestination(key.getWarpX(keyStack), 55.1, key.getWarpZ(keyStack), DungeonUtils.serializeDimensionKey(DimDungeons.DUNGEON_DIMENSION), enterFacing);
            } else if (key instanceof ItemBuildKey) {
                te.setDestination(key.getWarpX(keyStack), 51.1, key.getWarpZ(keyStack), DungeonUtils.serializeDimensionKey(DimDungeons.BUILD_DIMENSION), Direction.NORTH);
            }
        }
    }

    public static Direction getTeleporterHubEntranceDirection(int doornum) {
        Direction exitDirection = Direction.NORTH;
        if (doornum == 2 || doornum == 3) {
            exitDirection = Direction.EAST;
        }
        if (doornum == 4 || doornum == 5) {
            exitDirection = Direction.SOUTH;
        }
        if (doornum == 6 || doornum == 7) {
            exitDirection = Direction.WEST;
        }
        return exitDirection;
    }

    public static BlockPos getReturnPoint(BlockState state, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        switch (dir) {
            case WEST: {
                return pos.west().below(2);
            }
            case EAST: {
                return pos.east().below(2);
            }
            case NORTH: {
                return pos.north().below(2);
            }
            case SOUTH: {
                return pos.south().below(2);
            }
        }
        return pos.below(2);
    }

    public static boolean isOkayToSpawnPortalBlocks(Level worldIn, BlockPos pos, BlockState state, TileEntityPortalKeyhole myEntity) {
        Block b1 = worldIn.getBlockState(pos.below()).getBlock();
        Block b2 = worldIn.getBlockState(pos.below(2)).getBlock();
        if (b1 != Blocks.AIR && b1 != BlockRegistrar.BLOCK_GOLD_PORTAL.get()) {
            return false;
        }
        if (b2 != Blocks.AIR && b2 != BlockRegistrar.BLOCK_GOLD_PORTAL.get()) {
            return false;
        }
        ItemStack item = myEntity.getObjectInserted();
        if (item.getItem() instanceof BaseItemKey) {
            BaseItemKey key = (BaseItemKey)item.getItem();
            return key.isActivated(item);
        }
        return false;
    }

    protected boolean shouldBuildDungeon(ItemStack stack) {
        ItemPortalKey key;
        if (stack.getItem() instanceof ItemPortalKey && (key = (ItemPortalKey)stack.getItem()).isActivated(stack)) {
            return !key.isDungeonBuilt(stack);
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState retval = this.getMyCustomDefaultState();
        return (BlockState)retval.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        worldIn.setBlock(pos, (BlockState)state.setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite()), 2);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (state.getBlock() != newState.getBlock()) {
            if (tileentity instanceof TileEntityPortalKeyhole) {
                ItemStack item = ((TileEntityPortalKeyhole)tileentity).getObjectInserted();
                if (!item.isEmpty()) {
                    Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)item);
                }
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
            worldIn.removeBlockEntity(pos);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        if (((Boolean)blockState.getValue((Property)IS_BUILDING)).booleanValue()) {
            return 3;
        }
        if (((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            return 2;
        }
        return (Boolean)blockState.getValue((Property)FILLED) != false ? 1 : 0;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirrorIn.mirror((Direction)state.getValue((Property)FACING)));
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)this);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FILLED, LIT, IS_BUILDING});
    }

    public int predictPortalError(Level worldIn, Player playerIn) {
        return 0;
    }

    public static void checkForProblemsAndLiterallySpeakToPlayer(Level worldIn, BlockPos pos, BlockState state, TileEntityPortalKeyhole tileEntity, Player player, boolean dungeonExistsHere) {
        BlockState b;
        int i;
        if (worldIn.isClientSide || player == null) {
            return;
        }
        ItemStack item = tileEntity.getObjectInserted();
        if (!(item.getItem() instanceof BaseItemKey)) {
            return;
        }
        int keyLevel = 0;
        if (item.getItem() instanceof BaseItemKey) {
            BaseItemKey key = (BaseItemKey)item.getItem();
            if (!key.isActivated(item)) {
                BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 1, null);
                return;
            }
            keyLevel = key.getKeyLevel(item);
        }
        if (!BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, tileEntity)) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 2, null);
            return;
        }
        ArrayList<BlockState> blocks = state.getValue((Property)FACING) == Direction.WEST || state.getValue((Property)FACING) == Direction.EAST ? BlockGoldPortal.getPortalFrameMaterialsNorthSouth((LevelAccessor)worldIn, pos) : BlockGoldPortal.getPortalFrameMaterialsWestEast((LevelAccessor)worldIn, pos);
        for (i = 0; i < 5; ++i) {
            b = blocks.get(i);
            if (b.isAir()) {
                BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 3, null);
                return;
            }
            if (BlockGoldPortal.isValidPortalFrameBlock(b.getBlock())) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 4, b);
            return;
        }
        for (i = 5; i < 9; ++i) {
            b = blocks.get(i);
            if (b.isAir()) {
                BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 5, null);
                return;
            }
            if (BlockGoldPortal.isValidPortalFrameBlock(b.getBlock())) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 6, b);
            return;
        }
        for (i = 9; i < 11; ++i) {
            b = blocks.get(i);
            if (b.getBlock() == BlockRegistrar.BLOCK_GILDED_PORTAL.get()) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 7, b);
            return;
        }
        if (!dungeonExistsHere) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 11, null);
            return;
        }
        if (keyLevel < 2) {
            return;
        }
        for (i = 11; i < 13; ++i) {
            b = blocks.get(i);
            if (b.getBlock() == BlockRegistrar.BLOCK_PORTAL_CROWN.get()) continue;
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 8, null);
            return;
        }
        BlockState leftSpireA = blocks.get(13);
        BlockState leftSpireB = blocks.get(14);
        BlockState rightSpireA = blocks.get(15);
        BlockState rightSpireB = blocks.get(16);
        if (leftSpireA.getBlock() != Blocks.WHITE_WALL_BANNER && leftSpireA.getBlock() != Blocks.PURPLE_WALL_BANNER && leftSpireB.getBlock() != Blocks.WHITE_WALL_BANNER && leftSpireB.getBlock() != Blocks.PURPLE_WALL_BANNER) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 9, null);
            return;
        }
        if (rightSpireA.getBlock() != Blocks.WHITE_WALL_BANNER && rightSpireA.getBlock() != Blocks.PURPLE_WALL_BANNER && rightSpireB.getBlock() != Blocks.WHITE_WALL_BANNER && rightSpireB.getBlock() != Blocks.PURPLE_WALL_BANNER) {
            BlockPortalKeyhole.speakLiterallyToPlayerAboutProblems(worldIn, player, 9, null);
            return;
        }
    }

    public static void speakLiterallyToPlayerAboutProblems(Level worldIn, Player playerIn, int problemID, @Nullable BlockState problemBlock) {
        MutableComponent text1 = Component.translatable((String)Component.translatable((String)("error.dimdungeons.portal_error_" + problemID)).getString());
        if (problemBlock != null) {
            String blockName = problemBlock.getBlock().getName().getString();
            text1 = Component.literal((String)(Component.translatable((String)("error.dimdungeons.portal_error_" + problemID)).getString() + blockName + "."));
        }
        text1.withStyle(text1.getStyle().withItalic(Boolean.valueOf(true)));
        text1.withStyle(text1.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.displayClientMessage((Component)text1, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityPortalKeyhole(pos, state);
    }
}

