/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonDesignerTestShapes;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DungeonPlacementDebug
extends DungeonPlacement {
    public static boolean place(ServerLevel world, long x, long z, int debugType, DungeonGenData genData) {
        long entranceChunkX = x / 16L + 8L;
        long entranceChunkZ = z / 16L + 11L;
        if (!DungeonPlacementDebug.isEntranceChunk(entranceChunkX, entranceChunkZ)) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: debug dungeon does not start at " + x + ", " + z);
            return false;
        }
        DimDungeons.logMessageInfo("DIMDUNGEONS START DEBUG STRUCTURE at " + x + ", " + z);
        DungeonDesigner dbl = new DungeonDesigner(world.getRandom(), entranceChunkX, entranceChunkZ, DungeonDesigner.DungeonType.BASIC, genData.dungeonTheme);
        switch (debugType) {
            case 1: {
                DungeonDesignerTestShapes.MakeTestDungeonOne(dbl);
                break;
            }
            case 2: {
                DungeonDesignerTestShapes.MakeTestDungeonTwo(dbl);
                break;
            }
            case 3: {
                DungeonDesignerTestShapes.MakeTestDungeonThree(dbl);
                break;
            }
            case 4: {
                DungeonDesignerTestShapes.MakeTestDungeonFour(dbl);
                break;
            }
            case 5: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.FOURWAY);
                break;
            }
            case 6: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.THREEWAY);
                break;
            }
            case 7: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.HALLWAY);
                break;
            }
            case 8: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.CORNER);
                break;
            }
            case 9: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.END);
                break;
            }
            case 10: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.FOURWAY);
                break;
            }
            case 11: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.THREEWAY);
                break;
            }
            case 12: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.HALLWAY);
                break;
            }
            case 13: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.CORNER);
                break;
            }
            case 14: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.END);
                break;
            }
            case 15: {
                DungeonDesignerTestShapes.MakeTestDungeonForTheme(dbl, genData.dungeonTheme);
            }
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                ChunkPos cpos;
                DungeonRoom nextRoom = dbl.finalLayout[i][j];
                if (!nextRoom.hasRoom() || DungeonPlacementDebug.putRoomHere(cpos = new ChunkPos((int)x / 16 + i + 4, (int)z / 16 + j + 4), world, nextRoom, genData)) continue;
                DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE STRUCTURE: " + nextRoom.structure);
            }
        }
        return true;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ > 3L && plotZ < 12L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == 11L;
    }

    public static void putTestStructureHere(long x, long z, LevelAccessor world) {
        ChunkPos cpos = new ChunkPos((int)x, (int)z);
        MinecraftServer minecraftserver = ((Level)world).getServer();
        StructureTemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).getStructureManager();
        StructureTemplate template = templatemanager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"basic_template"));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setMirror(Mirror.NONE).setRotation(Rotation.NONE).setIgnoreEntities(false);
        placementsettings.setBoundingBox(placementsettings.getBoundingBox());
        placementsettings.setRotation(Rotation.NONE);
        BlockPos position = new BlockPos(cpos.getMinBlockX(), 50, cpos.getMinBlockZ());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        template.placeInWorld((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.getRandom(), 2);
    }

    public static boolean putRoomHere(ChunkPos cpos, ServerLevel world, DungeonRoom room, DungeonGenData genData) {
        MinecraftServer minecraftserver = world.getServer();
        StructureTemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).getStructureManager();
        StructureTemplate template = templatemanager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)room.structure));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setMirror(Mirror.NONE).setRotation(Rotation.NONE).setIgnoreEntities(false);
        placementsettings.setBoundingBox(placementsettings.getBoundingBox());
        placementsettings.setRotation(room.rotation);
        BlockPos position = new BlockPos(cpos.getMinBlockX(), 50, cpos.getMinBlockZ());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        if (template == null) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.setRotation(Rotation.COUNTERCLOCKWISE_90);
            position = position.offset(0, 0, template.getSize().getZ() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.setRotation(Rotation.CLOCKWISE_90);
            position = position.offset(template.getSize().getX() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.setRotation(Rotation.CLOCKWISE_180);
            position = position.offset(template.getSize().getX() - 1, 0, template.getSize().getZ() - 1);
        } else {
            placementsettings.setRotation(Rotation.NONE);
        }
        DimDungeons.logMessageInfo("Placing a room: " + room.structure);
        boolean success = template.placeInWorld((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.getRandom(), 2);
        for (StructureTemplate.StructureBlockInfo template$blockinfo : template.filterBlocks(position, placementsettings, Blocks.STRUCTURE_BLOCK)) {
            StructureMode structuremode;
            if (template$blockinfo.nbt() == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.nbt().getString("mode"))) != StructureMode.DATA) continue;
            DungeonPlacementDebug.handleDataBlock(template$blockinfo.nbt().getString("metadata"), template$blockinfo.pos(), world, world.getRandom(), placementsettings.getBoundingBox(), room);
        }
        return success;
    }
}

