/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.littleframes.LittleFramesConfig;
import team.creative.littleframes.LittleFramesRegistry;
import team.creative.littleframes.LittleTilesIntegration;
import team.creative.littleframes.client.LittleFramesClient;
import team.creative.littleframes.common.packet.CreativePictureFramePacket;
import team.creative.littleframes.common.packet.LittlePictureFramePacket;
import team.creative.littleframes.common.structure.LittlePictureFrame;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.type.premade.LittleStructureBuilder;

@Mod(value="littleframes")
public class LittleFrames {
    public static final String MODID = "littleframes";
    public static LittleFramesConfig CONFIG;
    public static final Logger LOGGER;
    public static final CreativeNetwork NETWORK;

    public LittleFrames(IEventBus bus) {
        bus.addListener(this::init);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            LittleFramesClient.load(bus);
        }
        LittleFramesRegistry.BLOCKS.register(bus);
        LittleFramesRegistry.ITEMS.register(bus);
        LittleFramesRegistry.BLOCK_ENTITIES.register(bus);
        bus.addListener(this::registerTabs);
    }

    private void init(FMLCommonSetupEvent event) {
        CONFIG = new LittleFramesConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        NETWORK.registerType(CreativePictureFramePacket.class, CreativePictureFramePacket::new);
        if (ModList.get().isLoaded("littletiles")) {
            NETWORK.registerType(LittlePictureFramePacket.class, LittlePictureFramePacket::new);
            LittleStructureBuilder.register((LittleStructureBuilder.LittleStructureBuilderType)new LittleStructureBuilder.LittleStructureBuilderType(LittleStructureRegistry.register((String)"little_picture_frame", LittlePictureFrame.class, LittlePictureFrame::new, (LittleAttributeBuilder)new LittleAttributeBuilder().tickRendering().ticking()).addOutput("playing", 1, SignalMode.TOGGLE, true), "frame"));
            LittleTilesIntegration.init();
        }
    }

    private void registerTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.BUILDING_BLOCKS)) {
            event.accept((ItemLike)LittleFramesRegistry.CREATIVE_PICTURE_FRAME.value());
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        NETWORK = new CreativeNetwork(1, LOGGER, ResourceLocation.tryBuild((String)MODID, (String)"main"));
    }
}

