/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeBlockModel;
import team.creative.creativecore.client.render.model.CreativeItemBoxModel;
import team.creative.creativecore.client.render.model.CreativeItemModel;
import team.creative.littleframes.LittleFramesRegistry;
import team.creative.littleframes.client.CreativePictureFrameRenderer;
import team.creative.littleframes.client.display.FrameVideoDisplay;
import team.creative.littleframes.common.block.BECreativePictureFrame;
import team.creative.littleframes.common.block.BlockCreativePictureFrame;

@OnlyIn(value=Dist.CLIENT)
public class LittleFramesClient {
    public static void load(IEventBus bus) {
        bus.addListener(LittleFramesClient::setup);
    }

    public static void setup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register(LittleFramesClient.class);
        CreativeCoreClient.registerClientConfig((String)"littleframes");
        CreativeCoreClient.registerItemModel((ResourceLocation)ResourceLocation.tryBuild((String)"littleframes", (String)"creative_pic_frame"), (CreativeItemModel)new CreativeItemBoxModel(new ModelResourceLocation(ResourceLocation.withDefaultNamespace((String)"stone"), "inventory")){

            public List<? extends RenderBox> getBoxes(ItemStack stack, boolean translucent) {
                return Collections.singletonList(new RenderBox(0.0f, 0.0f, 0.0f, 0.031f, 1.0f, 1.0f, Blocks.OAK_PLANKS));
            }
        });
        CreativeCoreClient.registerBlockModel((ResourceLocation)ResourceLocation.tryBuild((String)"littleframes", (String)"creative_pic_frame"), (CreativeBlockModel)new CreativeBlockModel(){
            public final ModelProperty<Boolean> visibility = new ModelProperty();
            public final ModelData visible = ModelData.builder().with(this.visibility, (Object)true).build();
            public final ModelData invisible = ModelData.builder().with(this.visibility, (Object)false).build();

            @NotNull
            public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof BECreativePictureFrame) {
                    BECreativePictureFrame frame = (BECreativePictureFrame)be;
                    return frame.visibleFrame ? this.visible : this.invisible;
                }
                return this.visible;
            }

            public List<? extends RenderBox> getBoxes(BlockState state, ModelData data, RandomSource source) {
                if (data.has(this.visibility) && !((Boolean)data.get(this.visibility)).booleanValue()) {
                    return Collections.EMPTY_LIST;
                }
                RenderBox box = new RenderBox(BlockCreativePictureFrame.box((Direction)state.getValue((Property)BlockCreativePictureFrame.FACING)), Blocks.OAK_PLANKS);
                return Collections.singletonList(box);
            }
        });
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)LittleFramesRegistry.BE_CREATIVE_FRAME.value()), x -> new CreativePictureFrameRenderer());
    }

    @SubscribeEvent
    public static void render(ClientTickEvent.Pre event) {
        FrameVideoDisplay.tick();
    }

    @SubscribeEvent
    public static void unload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            FrameVideoDisplay.unload();
        }
    }
}

