/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.display;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import org.watermedia.api.math.MathAPI;
import org.watermedia.api.player.PlayerAPI;
import org.watermedia.api.player.videolan.VideoPlayer;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.display.FramePictureDisplay;
import team.creative.littleframes.common.data.LittleFrameData;

public class FrameVideoDisplay
extends FrameDisplay {
    private static final int ACCEPTABLE_SYNC_TIME = 1000;
    private static final List<FrameVideoDisplay> OPEN_DISPLAYS = new ArrayList<FrameVideoDisplay>();
    public VideoPlayer player;
    private final Vec3d pos;
    private boolean stream = false;
    private volatile float lastSetVolume;
    private volatile float lastPlaybackSpeed;
    private long lastCorrectedTime = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                if (!Minecraft.getInstance().isPaused()) continue;
                if (display.stream) {
                    if (!display.player.isPlaying()) continue;
                    display.player.setPauseMode(true);
                    continue;
                }
                if (display.player.getDuration() <= 0L || !display.player.isPlaying()) continue;
                display.player.setPauseMode(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                display.free();
            }
            OPEN_DISPLAYS.clear();
        }
    }

    public static FrameDisplay createVideoDisplay(Vec3d pos, LittleFrameData data) {
        if (PlayerAPI.isReady()) {
            FrameVideoDisplay display = new FrameVideoDisplay(pos, data);
            OPEN_DISPLAYS.add(display);
            return display;
        }
        return FramePictureDisplay.VLC_FAILED;
    }

    public FrameVideoDisplay(Vec3d pos, LittleFrameData data) {
        this.pos = pos;
        this.player = new VideoPlayer((Executor)Minecraft.getInstance());
        float tempVolume = this.getVolume(data);
        this.player.setVolume((int)tempVolume);
        this.lastSetVolume = tempVolume;
        this.lastPlaybackSpeed = (float)data.playbackSpeed;
        this.player.setSpeed(this.lastPlaybackSpeed);
        this.player.setRepeatMode(data.loop);
        this.player.start(data.getURI());
    }

    public int getVolume(LittleFrameData data) {
        if (this.player == null) {
            return 0;
        }
        float distance = (float)this.pos.distance(Minecraft.getInstance().player.getPosition(CreativeCoreClient.getFrameTime()));
        if (data.minDistance > data.maxDistance) {
            float temp = data.maxDistance;
            data.maxDistance = data.minDistance;
            data.minDistance = temp;
        }
        float volume = data.ingameVolume();
        if (distance > data.minDistance) {
            volume = distance > data.maxDistance ? 0.0f : (volume *= 1.0f - (distance - data.minDistance) / (data.maxDistance - data.minDistance));
        }
        return (int)(volume * 100.0f);
    }

    @Override
    public void tick(LittleFrameData data, boolean playing) {
        float speed;
        if (this.player == null) {
            return;
        }
        float volume = this.getVolume(data);
        if (volume != this.lastSetVolume) {
            this.player.setVolume((int)volume);
            this.lastSetVolume = volume;
        }
        if ((speed = (float)data.playbackSpeed) != this.lastPlaybackSpeed) {
            this.player.setSpeed(speed);
            this.lastPlaybackSpeed = speed;
        }
        if (this.player.isValid()) {
            boolean realPlaying;
            boolean bl = realPlaying = playing && !Minecraft.getInstance().isPaused();
            if (this.player.getRepeatMode() != data.loop) {
                this.player.setRepeatMode(data.loop);
            }
            long tickTime = 50L;
            this.stream = this.player.isLive();
            if (this.stream) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
            } else if (this.player.getDuration() > 0L) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
                if (this.player.isSeekAble()) {
                    long time = (long)((float)((long)data.tick * tickTime + (realPlaying ? (long)(CreativeCoreClient.getFrameTime() * (float)tickTime) : 0L)) * this.lastPlaybackSpeed);
                    if (time > this.player.getTime() && data.loop) {
                        long mediaDuration = this.player.getMediaInfoDuration();
                        long l = time = time == 0L || mediaDuration == 0L ? 0L : Math.floorMod(time, this.player.getMediaInfoDuration());
                    }
                    if (Math.abs(time - this.player.getTime()) > 1000L && Math.abs(time - this.lastCorrectedTime) > 1000L) {
                        this.lastCorrectedTime = time;
                        this.player.seekTo(time);
                    }
                }
            }
        }
    }

    @Override
    public void prepare(LittleFrameData data, boolean playing) {
        if (this.player == null) {
            return;
        }
        this.player.preRender();
    }

    public void free() {
        if (this.player != null) {
            VideoPlayer tempPlayer = this.player;
            tempPlayer.release();
        }
        this.player = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.free();
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            OPEN_DISPLAYS.remove(this);
        }
    }

    @Override
    public int texture() {
        return this.player.texture();
    }

    @Override
    public void pause(LittleFrameData data, boolean playing) {
        if (this.player == null) {
            return;
        }
        this.player.seekTo(MathAPI.tickToMs((long)data.tick));
        this.player.pause();
    }

    @Override
    public void resume(LittleFrameData data, boolean playing) {
        if (this.player == null) {
            return;
        }
        this.player.seekTo(MathAPI.tickToMs((long)data.tick));
        this.player.play();
    }

    @Override
    public int getWidth() {
        return this.player.width();
    }

    @Override
    public int getHeight() {
        return this.player.height();
    }

    @Override
    public boolean canTick() {
        return this.player != null && this.player.isSafeUse();
    }
}

