/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.gui;

import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageCache;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiTable;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiDuration;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.control.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiSliderSingleDigit;
import team.creative.littleframes.client.gui.GuiUrlTextfield;
import team.creative.littleframes.common.structure.LittlePictureFrame;

public class GuiLittlePictureFrame
extends GuiLayer {
    public LittlePictureFrame frame;
    public GuiTextfield url;
    public final GuiSyncLocal<EndTag> PLAY = this.getSyncHolder().register("play", x -> this.frame.play());
    public final GuiSyncLocal<EndTag> PAUSE = this.getSyncHolder().register("pause", x -> this.frame.pause());
    public final GuiSyncLocal<EndTag> STOP = this.getSyncHolder().register("stop", x -> this.frame.stop());
    public final GuiSyncLocal<CompoundTag> SET_DATA = this.getSyncHolder().register("set_data", nbt -> {
        String url = nbt.getString("url");
        if (LittleFrames.CONFIG.canUse(this.getPlayer(), url)) {
            try {
                this.frame.setURL(new URI(url));
            }
            catch (URISyntaxException e) {
                LittleFrames.LOGGER.error("Failed to save url '{}'", (Object)url);
            }
            this.frame.data.renderDistance = Math.min(LittleFrames.CONFIG.maxRenderDistance, nbt.getInt("render"));
            this.frame.fitMode = LittlePictureFrame.FitMode.values()[nbt.getInt("fit")];
            this.frame.data.loop = nbt.getBoolean("loop");
            this.frame.data.volume(nbt.getFloat("volume"));
            this.frame.data.minDistance = nbt.getFloat("min");
            this.frame.data.maxDistance = nbt.getFloat("max");
            this.frame.data.alpha = nbt.getFloat("transparency");
            this.frame.data.brightness = nbt.getFloat("brightness");
            this.frame.data.playbackSpeed = nbt.getDouble("speed");
            this.frame.data.refreshCounter = this.frame.data.refreshInterval = nbt.getInt("refresh");
        }
        this.frame.updateStructure();
    });

    public GuiLittlePictureFrame(LittlePictureFrame frame) {
        super("little_frame", 200, 180);
        this.frame = frame;
    }

    public void create() {
        GuiButton save = new GuiButton("save", x -> {
            CompoundTag nbt = new CompoundTag();
            GuiTextfield url = (GuiTextfield)this.get("url");
            GuiSteppedSlider renderDistance = (GuiSteppedSlider)this.get("distance");
            GuiStateButton fit = (GuiStateButton)this.get("fit");
            GuiSlider transparency = (GuiSlider)this.get("transparency");
            GuiSlider brightness = (GuiSlider)this.get("brightness");
            GuiCheckBox loop = (GuiCheckBox)this.get("loop");
            GuiSlider volume = (GuiSlider)this.get("volume");
            GuiSteppedSlider min = (GuiSteppedSlider)this.get("range_min");
            GuiSteppedSlider max = (GuiSteppedSlider)this.get("range_max");
            GuiCheckBox autoRefresh = (GuiCheckBox)this.get("autoRefresh");
            GuiDuration duration = (GuiDuration)this.get("duration");
            GuiSlider speed = (GuiSlider)this.get("speed");
            nbt.putInt("fit", ((LittlePictureFrame.FitMode)((Object)((Object)fit.selected()))).ordinal());
            nbt.putInt("render", (int)renderDistance.getValue());
            nbt.putFloat("transparency", (float)transparency.getValue());
            nbt.putFloat("brightness", (float)brightness.getValue());
            nbt.putBoolean("loop", loop.value);
            nbt.putFloat("volume", (float)volume.getValue());
            nbt.putFloat("min", (float)min.getIntValue());
            nbt.putFloat("max", (float)max.getIntValue());
            nbt.putString("url", url.getText());
            nbt.putDouble("speed", Math.max(0.1, speed.getValue()));
            nbt.putInt("refresh", autoRefresh.value ? duration.getDuration() : -1);
            nbt.putInt("type", 0);
            this.SET_DATA.send((Tag)nbt);
        });
        save.setTranslate("gui.save");
        this.align = Align.STRETCH;
        this.flow = GuiFlow.STACK_Y;
        this.url = new GuiUrlTextfield(save, "url", this.frame.data.getURIPath());
        this.add((GuiControl)this.url);
        GuiLabel error = new GuiLabel("error").setDefaultColor(-65536);
        if (this.frame.isClient() && this.frame.cache != null && this.frame.cache.getStatus().equals((Object)ImageCache.Status.FAILED)) {
            Exception e = this.frame.cache.getException();
            if (this.frame.cache.isVideo()) {
                if (!LittleFrames.CONFIG.useVLC) {
                    error.setTitle((Component)Component.literal((String)"Image not found"));
                }
            } else if (e.getMessage() == null) {
                error.setTranslate("download.exception.invalid");
            } else if (e.getMessage().startsWith("Server returned HTTP response code: 403")) {
                error.setTranslate("download.exception.forbidden");
            } else if (e.getMessage().startsWith("Server returned HTTP response code: 404")) {
                error.setTranslate("download.exception.notfound");
            } else {
                error.setTranslate("download.exception.invalid");
            }
        }
        this.add((GuiControl)error);
        GuiStateButton button = new GuiStateButton("fit", (IComponentMap)new TextMapBuilder().addComponent((Object[])LittlePictureFrame.FitMode.values(), x -> Component.translatable((String)("gui.little_frame.fitmode." + x.name()))));
        button.select((Object)this.frame.fitMode);
        this.add((GuiControl)button);
        GuiTable table = new GuiTable();
        this.add((GuiControl)table);
        GuiColumn left = new GuiColumn();
        GuiColumn right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("t_label").setTitle((Component)Component.translatable((String)"gui.creative_frame.transparency").append(":")));
        right.add(new GuiSlider("transparency", (double)this.frame.data.alpha, 0.0, 1.0).setExpandableX());
        left = new GuiColumn();
        right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("b_label").setTitle((Component)Component.translatable((String)"gui.creative_frame.brightness").append(":")));
        right.add(new GuiSlider("brightness", (double)this.frame.data.brightness, 0.0, 1.0).setExpandableX());
        left = new GuiColumn();
        right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("d_label").setTitle((Component)Component.translatable((String)"gui.creative_frame.distance").append(":")));
        right.add(new GuiSteppedSlider("distance", this.frame.data.renderDistance, 5, 1024).setExpandableX());
        GuiParent play = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)play);
        play.add((GuiControl)new GuiButtonIcon("play", Icon.PLAY, x -> this.PLAY.send((Tag)EndTag.INSTANCE)));
        play.add((GuiControl)new GuiButtonIcon("pause", Icon.PAUSE, x -> this.PAUSE.send((Tag)EndTag.INSTANCE)));
        play.add((GuiControl)new GuiButtonIcon("stop", Icon.STOP, x -> this.STOP.send((Tag)EndTag.INSTANCE)));
        this.add((GuiControl)new GuiCheckBox("loop", this.frame.data.loop).setTranslate("gui.creative_frame.loop"));
        GuiParent playOther = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)playOther);
        playOther.add((GuiControl)new GuiLabeledControl("gui.creative_frame.volume", new GuiSlider("volume", (double)this.frame.data.volume(), 0.0, 1.0).setExpandableX()));
        playOther.add((GuiControl)new GuiLabeledControl("gui.creative_frame.speed", new GuiSliderSingleDigit("speed", this.frame.data.playbackSpeed, 0.1, 2.0).setExpandableX()));
        GuiParent range = new GuiParent();
        this.add((GuiControl)range);
        range.add((GuiControl)new GuiLabel("range_label").setTranslate("gui.creative_frame.range"));
        range.add(new GuiSteppedSlider("range_min", (int)this.frame.data.minDistance, 0, 512).setExpandableX());
        range.add(new GuiSteppedSlider("range_max", (int)this.frame.data.maxDistance, 0, 512).setExpandableX());
        GuiParent refresh = new GuiParent();
        refresh.spacing = 10;
        this.add((GuiControl)refresh.setVAlign(VAlign.CENTER));
        refresh.add((GuiControl)new GuiCheckBox("autoRefresh", this.frame.data.refreshInterval > 0).setTranslate("gui.creative_frame.autoReload"));
        refresh.add((GuiControl)new GuiDuration("duration", this.frame.data.refreshInterval, false, true, true, true));
        GuiParent bottom = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        bottom.align = Align.RIGHT;
        this.add((GuiControl)bottom);
        save.setEnabled(LittleFrames.CONFIG.canUse(this.getPlayer(), this.url.getText()));
        bottom.add((GuiControl)save);
        bottom.add(new GuiButton("reload", x -> {
            if (Screen.hasShiftDown()) {
                ImageAPI.reloadCache();
            } else if (this.frame.cache != null) {
                this.frame.cache.reload();
            }
        }).setTranslate("gui.creative_frame.reload").setTooltip(new TextBuilder().translate("gui.creative_frame.reloadtooltip").build()));
    }
}

