/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.block;

import java.net.URI;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageCache;
import team.creative.creativecore.common.be.BlockEntityCreative;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.vec.Vec2f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.LittleFramesRegistry;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.display.FramePictureDisplay;
import team.creative.littleframes.client.display.FrameVideoDisplay;
import team.creative.littleframes.common.block.BlockCreativePictureFrame;
import team.creative.littleframes.common.data.LittleFrameData;
import team.creative.littleframes.common.packet.CreativePictureFramePacket;

public class BECreativePictureFrame
extends BlockEntityCreative {
    public Vec2f min = new Vec2f(0.0f, 0.0f);
    public Vec2f max = new Vec2f(1.0f, 1.0f);
    public float rotation = 0.0f;
    public boolean flipX = false;
    public boolean flipY = false;
    public boolean visibleFrame = true;
    public boolean bothSides = false;
    public boolean playing = true;
    public LittleFrameData data = new LittleFrameData();
    private boolean released = false;
    @OnlyIn(value=Dist.CLIENT)
    public ImageCache cache;
    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay display;

    public BECreativePictureFrame(BlockPos pos, BlockState state) {
        super((BlockEntityType)LittleFramesRegistry.BE_CREATIVE_FRAME.get(), pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isURLEmpty() {
        return !this.data.hasURI();
    }

    public void setURL(URI url) {
        this.data.setURI(url);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay requestDisplay() {
        if (!this.data.hasURI() && this.display != null) {
            this.cleanDisplay();
            return null;
        }
        if (this.released) {
            this.cache = null;
            return null;
        }
        if (this.cache == null && !this.data.hasURI()) {
            this.cleanDisplay();
            return null;
        }
        if (this.cache == null || this.data.hasURI() && !this.cache.uri.equals(this.data.getURI())) {
            this.cache = ImageAPI.getCache((URI)this.data.getURI(), (Executor)Minecraft.getInstance());
            this.cleanDisplay();
        }
        switch (this.cache.getStatus()) {
            case READY: {
                if (this.display != null) {
                    return this.display;
                }
                if (this.cache.isVideo()) {
                    this.display = FrameVideoDisplay.createVideoDisplay(new Vec3d((Vec3i)this.worldPosition), this.data);
                    return this.display;
                }
                this.display = new FramePictureDisplay(this.cache);
                return this.display;
            }
            case WAITING: {
                this.cleanDisplay();
                this.cache.load();
                return this.display;
            }
            case LOADING: 
            case FAILED: {
                return null;
            }
            case FORGOTTEN: {
                LittleFrames.LOGGER.warn("Cached picture is forgotten, cleaning and reloading");
                this.cache = null;
                return null;
            }
        }
        LittleFrames.LOGGER.warn("WATERMeDIA Behavior is modified, this shouldn't be executed");
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cleanDisplay() {
        if (this.display != null) {
            this.display.release();
            this.display = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void release() {
        this.cleanDisplay();
        this.released = true;
    }

    public AlignedBox getBox() {
        Direction direction = (Direction)this.getBlockState().getValue((Property)BlockCreativePictureFrame.FACING);
        Facing facing = Facing.get((Direction)direction);
        AlignedBox box = BlockCreativePictureFrame.box(direction);
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        box.setMin(one, this.min.x);
        box.setMax(one, this.max.x);
        box.setMin(two, this.min.y);
        box.setMax(two, this.max.y);
        return box;
    }

    public float getSizeX() {
        return this.max.x - this.min.x;
    }

    public float getSizeY() {
        return this.max.y - this.min.y;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        this.savePicture(nbt);
    }

    public void play() {
        this.playing = true;
        LittleFrames.NETWORK.sendToClient((CreativePacket)new CreativePictureFramePacket(this.worldPosition, this.playing, this.data.tick), this.level, this.worldPosition);
    }

    public void pause() {
        this.playing = false;
        LittleFrames.NETWORK.sendToClient((CreativePacket)new CreativePictureFramePacket(this.worldPosition, this.playing, this.data.tick), this.level, this.worldPosition);
    }

    public void stop() {
        this.playing = false;
        this.data.stop();
        LittleFrames.NETWORK.sendToClient((CreativePacket)new CreativePictureFramePacket(this.worldPosition, this.playing, this.data.tick), this.level, this.worldPosition);
    }

    protected void savePicture(CompoundTag nbt) {
        nbt.putFloat("minx", this.min.x);
        nbt.putFloat("miny", this.min.y);
        nbt.putFloat("maxx", this.max.x);
        nbt.putFloat("maxy", this.max.y);
        nbt.putFloat("rotation", this.rotation);
        nbt.putBoolean("visibleFrame", this.visibleFrame);
        nbt.putBoolean("bothSides", this.bothSides);
        nbt.putBoolean("flipX", this.flipX);
        nbt.putBoolean("flipY", this.flipY);
        nbt.putBoolean("playing", this.playing);
        nbt.put("data", (Tag)this.data.save());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.loadPicture(nbt);
    }

    protected void loadPicture(CompoundTag nbt) {
        this.min.x = nbt.getFloat("minx");
        this.min.y = nbt.getFloat("miny");
        this.max.x = nbt.getFloat("maxx");
        this.max.y = nbt.getFloat("maxy");
        this.rotation = nbt.getFloat("rotation");
        this.visibleFrame = nbt.getBoolean("visibleFrame");
        this.bothSides = nbt.getBoolean("bothSides");
        this.flipX = nbt.getBoolean("flipX");
        this.flipY = nbt.getBoolean("flipY");
        this.playing = nbt.getBoolean("playing");
        this.data = nbt.contains("data") ? new LittleFrameData(nbt.getCompound("data")) : (nbt.contains("url") ? LittleFrameData.ofOldData(nbt) : new LittleFrameData());
    }

    public void handleUpdate(CompoundTag nbt, boolean chunkUpdate) {
        this.loadPicture(nbt);
        this.markDirty();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BECreativePictureFrame) {
            BECreativePictureFrame be = (BECreativePictureFrame)blockEntity;
            if (level.isClientSide) {
                FrameDisplay display = be.requestDisplay();
                if (display != null && display.canTick()) {
                    display.tick(be.data, be.playing);
                }
                if (be.data.refreshInterval > 0) {
                    if (be.data.refreshCounter <= 0) {
                        be.data.refreshCounter = be.data.refreshInterval;
                        if (be.cache != null) {
                            be.cache.reload();
                        }
                    } else {
                        --be.data.refreshCounter;
                    }
                }
            }
            if (be.playing) {
                ++be.data.tick;
            }
        }
    }

    public void setRemoved() {
        if (this.isClient() && this.display != null) {
            this.release();
        }
        super.setRemoved();
    }

    public void onChunkUnloaded() {
        if (this.isClient() && this.display != null) {
            this.release();
        }
        super.onChunkUnloaded();
    }
}

