/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiCreativePictureFrame;
import team.creative.littleframes.common.block.BECreativePictureFrame;

public class BlockCreativePictureFrame
extends BaseEntityBlock
implements BlockGuiCreator {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final float frameThickness = 0.031f;

    public static AlignedBox box(Direction direction) {
        Facing facing = Facing.get((Direction)direction);
        AlignedBox box = new AlignedBox();
        if (facing.positive) {
            box.setMax(facing.axis, 0.031f);
        } else {
            box.setMin(facing.axis, 0.969f);
        }
        return box;
    }

    public BlockCreativePictureFrame() {
        super(BlockBehaviour.Properties.of().explosionResistance(2.5f).destroyTime(2.0f).noOcclusion());
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BlockCreativePictureFrame.box((Direction)state.getValue((Property)FACING)).voxelShape();
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return BlockCreativePictureFrame.box((Direction)state.getValue((Property)FACING)).voxelShape();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide && LittleFrames.CONFIG.canInteract(player, level)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BECreativePictureFrame::tick;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BECreativePictureFrame(pos, state);
    }

    public GuiLayer create(CompoundTag nbt, Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof BECreativePictureFrame) {
            BECreativePictureFrame frame = (BECreativePictureFrame)be;
            return new GuiCreativePictureFrame(frame);
        }
        return null;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block p_55669_, BlockPos otherPos, boolean p_55671_) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof BECreativePictureFrame) {
            BECreativePictureFrame frame = (BECreativePictureFrame)be;
            if (frame.playing == level.hasNeighborSignal(pos)) {
                if (frame.playing) {
                    frame.pause();
                } else {
                    frame.play();
                }
            }
        }
    }
}

