/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.data;

import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.littleframes.LittleFrames;

public class LittleFrameData {
    private URI uri;
    public float brightness = 1.0f;
    public float alpha = 1.0f;
    public int renderDistance = 64;
    private float volume = 1.0f;
    public float minDistance = 5.0f;
    public float maxDistance = 20.0f;
    public boolean loop = true;
    public int tick = 0;
    public int refreshInterval = -1;
    public int refreshCounter = 0;
    public double playbackSpeed = 1.0;

    public static LittleFrameData ofOldData(CompoundTag nbt) {
        LittleFrameData data = new LittleFrameData();
        try {
            data.uri = new URI(nbt.getString("url"));
        }
        catch (URISyntaxException e) {
            LittleFrames.LOGGER.error("Tried to load invalid url '{}'", (Object)nbt.getString("url"));
            data.uri = null;
        }
        if (nbt.contains("render")) {
            data.renderDistance = nbt.getInt("render");
        }
        if (nbt.contains("alpha")) {
            data.alpha = nbt.getFloat("alpha");
        }
        if (nbt.contains("brightness")) {
            data.brightness = nbt.getFloat("brightness");
        }
        data.volume = nbt.getFloat("volume");
        if (nbt.contains("min")) {
            data.minDistance = nbt.getFloat("min");
        }
        if (nbt.contains("max")) {
            data.maxDistance = nbt.getFloat("max");
        }
        data.tick = nbt.getInt("tick");
        data.loop = nbt.getBoolean("loop");
        int n = data.refreshInterval = nbt.contains("refresh") ? nbt.getInt("refresh") : -1;
        if (data.refreshInterval > 0) {
            data.refreshCounter = data.refreshInterval;
        }
        return data;
    }

    public LittleFrameData() {
    }

    public LittleFrameData(CompoundTag nbt) {
        try {
            this.uri = nbt.contains("u") ? new URI(nbt.getString("u")) : null;
        }
        catch (URISyntaxException e) {
            LittleFrames.LOGGER.error("Tried to load invalid url '{}'", (Object)nbt.getString("u"));
            this.uri = null;
        }
        if (nbt.contains("d")) {
            this.renderDistance = nbt.getInt("d");
        }
        if (nbt.contains("a")) {
            this.alpha = nbt.getFloat("a");
        }
        if (nbt.contains("b")) {
            this.brightness = nbt.getFloat("b");
        }
        this.volume = nbt.getFloat("v");
        if (nbt.contains("min")) {
            this.minDistance = nbt.getFloat("min");
        }
        if (nbt.contains("max")) {
            this.maxDistance = nbt.getFloat("max");
        }
        this.tick = nbt.getInt("t");
        this.loop = nbt.getBoolean("l");
        this.playbackSpeed = nbt.contains("speed") ? nbt.getDouble("speed") : 1.0;
        int n = this.refreshInterval = nbt.contains("r") ? nbt.getInt("r") : -1;
        if (this.refreshInterval > 0) {
            this.refreshCounter = this.refreshInterval;
        }
    }

    public boolean hasURI() {
        return this.uri != null;
    }

    public void setURI(URI uri) {
        this.uri = uri.toString().isBlank() ? null : uri;
    }

    public void stop() {
        this.tick = 0;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getURIPath() {
        return this.uri != null ? this.uri.toString() : "";
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        if (this.uri != null) {
            nbt.putString("u", this.uri.toString());
        }
        nbt.putInt("d", this.renderDistance);
        nbt.putFloat("a", this.alpha);
        nbt.putFloat("b", this.brightness);
        nbt.putFloat("v", this.volume);
        nbt.putFloat("min", this.minDistance);
        nbt.putFloat("max", this.maxDistance);
        nbt.putInt("t", this.tick);
        nbt.putBoolean("l", this.loop);
        nbt.putDouble("speed", this.playbackSpeed);
        if (this.refreshInterval < 0) {
            nbt.remove("r");
        } else {
            nbt.putInt("r", this.refreshInterval);
        }
        return nbt;
    }

    public void volume(float volume) {
        this.volume = volume;
    }

    public float volume() {
        return this.volume;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float ingameVolume() {
        return this.volume * Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MASTER);
    }
}

