/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.structure;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.net.URI;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageCache;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.LittleTilesIntegration;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.display.FramePictureDisplay;
import team.creative.littleframes.client.display.FrameVideoDisplay;
import team.creative.littleframes.common.data.LittleFrameData;
import team.creative.littleframes.common.packet.LittlePictureFramePacket;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.relative.StructureRelative;

public class LittlePictureFrame
extends LittleStructure {
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public Facing facing;
    @StructureDirectional
    public Vec3f topRight;
    public FitMode fitMode = FitMode.CROP;
    public LittleFrameData data;
    public boolean released = false;
    @OnlyIn(value=Dist.CLIENT)
    public ImageCache cache;
    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay display;

    public LittlePictureFrame(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isURLEmpty() {
        return !this.data.hasURI();
    }

    public void setURL(URI url) {
        this.data.setURI(url);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay requestDisplay() {
        if (!this.data.hasURI() && this.display != null) {
            this.cleanDisplay();
            return null;
        }
        if (this.released) {
            this.cache = null;
            return null;
        }
        if (this.cache == null && !this.data.hasURI()) {
            this.cleanDisplay();
            return null;
        }
        if (this.cache == null || this.data.hasURI() && !this.cache.uri.equals(this.data.getURI())) {
            this.cache = ImageAPI.getCache((URI)this.data.getURI(), (Executor)Minecraft.getInstance());
            this.cleanDisplay();
        }
        switch (this.cache.getStatus()) {
            case READY: {
                if (this.display != null) {
                    return this.display;
                }
                if (this.cache.isVideo()) {
                    this.display = FrameVideoDisplay.createVideoDisplay(new Vec3d((Vec3i)this.getStructurePos()), this.data);
                    return this.display;
                }
                this.display = new FramePictureDisplay(this.cache);
                return this.display;
            }
            case WAITING: {
                this.cleanDisplay();
                this.cache.load();
                return this.display;
            }
            case FAILED: {
                return null;
            }
            case FORGOTTEN: {
                LittleFrames.LOGGER.warn("Cached picture is forgotten, cleaning and reloading");
                this.cache = null;
                return null;
            }
            case LOADING: {
                return null;
            }
        }
        LittleFrames.LOGGER.warn("WATERMeDIA Behavior is modified, this shouldn't be executed");
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cleanDisplay() {
        if (this.display != null) {
            this.display.release();
            this.display = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void release() {
        this.cleanDisplay();
        this.released = true;
    }

    public void play() {
        if (!this.getOutput(0).getState().any()) {
            this.getOutput(0).toggle();
        }
    }

    public void pause() {
        if (this.getOutput(0).getState().any()) {
            this.getOutput(0).toggle();
        }
    }

    public void stop() {
        if (this.getOutput(0).getState().any()) {
            this.getOutput(0).toggle();
        }
        this.data.stop();
        LittleFrames.NETWORK.sendToClient((CreativePacket)new LittlePictureFramePacket(this.getStructureLocation(), this.getOutput(0).getState().any(), this.data.tick), this.getStructureLevel(), this.getStructurePos());
    }

    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        this.fitMode = FitMode.values()[nbt.getInt("fitMode")];
        this.data = nbt.contains("data") ? new LittleFrameData(nbt.getCompound("data")) : (nbt.contains("url") ? LittleFrameData.ofOldData(nbt) : new LittleFrameData());
    }

    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("fitMode", this.fitMode.ordinal());
        nbt.put("data", (Tag)this.data.save());
    }

    public boolean canInteract() {
        return true;
    }

    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        LittleTilesIntegration.LITTLE_FRAME_GUI.open(player, (LittleStructure)this);
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(PoseStack pose, MultiBufferSource buffer, BlockPos pos, float partialTickTime) {
        if (this.isURLEmpty() || this.data.alpha == 0.0f) {
            if (this.display != null) {
                this.display.release();
            }
            return;
        }
        FrameDisplay display = this.requestDisplay();
        if (display == null) {
            return;
        }
        display.prepare(this.data, this.getOutput(0).getState().any());
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)this.data.brightness, (float)this.data.brightness, (float)this.data.brightness, (float)this.data.alpha);
        int texture = display.texture();
        RenderSystem.bindTexture((int)texture);
        RenderSystem.setShaderTexture((int)0, (int)texture);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        AlignedBox box = this.frame.getBox().getBox(this.frame.getGrid());
        BoxFace face = BoxFace.get((Facing)this.facing);
        if (this.facing.positive) {
            box.setMax(this.facing.axis, box.getMin(this.facing.axis) + 0.01f);
        } else {
            box.setMin(this.facing.axis, box.getMax(this.facing.axis) - 0.01f);
        }
        Axis uAxis = face.getTexUAxis();
        Axis vAxis = face.getTexVAxis();
        if (this.fitMode == FitMode.CROP) {
            float videoRatio;
            float height;
            float width = box.getSize(uAxis);
            float ratio = width / (height = box.getSize(vAxis));
            if (ratio > (videoRatio = (float)display.getWidth() / (float)display.getHeight())) {
                box.shrink(uAxis, width - height * videoRatio);
            } else if (ratio < videoRatio) {
                box.shrink(vAxis, height - width / videoRatio);
            }
        }
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f mat = pose.last().pose();
        for (BoxCorner corner : face.corners) {
            builder.addVertex(mat, box.get(corner.x), box.get(corner.y), box.get(corner.z)).setUv(corner.isFacingPositive(uAxis) != this.topRight.get(uAxis) > 0.0f ? 1.0f : 0.0f, corner.isFacingPositive(vAxis) != this.topRight.get(vAxis) > 0.0f ? 1.0f : 0.0f).setColor(255, 255, 255, 255);
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getMaxRenderDistance() {
        return this.data.renderDistance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.frame.getBox().getBB(this.frame.getGrid());
    }

    public void tick() {
        super.tick();
        if (this.isClient()) {
            FrameDisplay display = this.requestDisplay();
            if (display != null && display.canTick()) {
                display.tick(this.data, this.getOutput(0).getState().any());
            }
            if (this.data.refreshInterval > 0) {
                if (this.data.refreshCounter <= 0) {
                    this.data.refreshCounter = this.data.refreshInterval;
                    if (this.cache != null) {
                        this.cache.reload();
                    }
                } else {
                    --this.data.refreshCounter;
                }
            }
        }
        if (this.getOutput(0).getState().any()) {
            ++this.data.tick;
        }
    }

    public void unload() {
        super.unload();
        if (this.isClient() && this.display != null) {
            this.release();
        }
    }

    public static enum FitMode {
        CROP,
        STRETCH;

    }
}

