/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.data.AccessoriesBaseData;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.AdjustAttributeModifierCallback;
import io.wispforest.accessories.api.events.CanEquipCallback;
import io.wispforest.accessories.api.events.CanUnequipCallback;
import io.wispforest.accessories.api.slot.EntityBasedPredicate;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.AccessoryBreak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesAPI {
    private static final Logger LOGGER = LogUtils.getLogger();
    @ApiStatus.Internal
    public static final Accessory DEFAULT = new Accessory(){

        @Override
        public int maxStackSize(ItemStack stack) {
            AccessoryStackSizeComponent data = (AccessoryStackSizeComponent)stack.getOrDefault(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT);
            if (data.useStackSize()) {
                return stack.getMaxStackSize();
            }
            return Math.min(Math.max(data.sizeOverride(), 1), stack.getMaxStackSize());
        }
    };
    @ApiStatus.Internal
    private static final AccessoryNest DEFAULT_NEST = new AccessoryNest(){

        @Override
        public int maxStackSize(ItemStack stack) {
            AccessoryStackSizeComponent data = (AccessoryStackSizeComponent)stack.getOrDefault(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT);
            if (data.useStackSize()) {
                return stack.getMaxStackSize();
            }
            return Math.min(Math.max(data.sizeOverride(), 1), stack.getMaxStackSize());
        }
    };
    private static final Map<ResourceLocation, SlotBasedPredicate> PREDICATE_REGISTRY = new HashMap<ResourceLocation, SlotBasedPredicate>();
    private static final Map<Item, Accessory> REGISTER = new HashMap<Item, Accessory>();
    @Deprecated(forRemoval=true)
    public static final TagKey<Item> ALL_ACCESSORIES = AccessoriesTags.ALL_TAG;
    @Deprecated(forRemoval=true)
    public static final TagKey<Item> ANY_ACCESSORIES = AccessoriesTags.ANY_TAG;

    @ApiStatus.Internal
    public static Map<Item, Accessory> getAllAccessories() {
        return Collections.unmodifiableMap(REGISTER);
    }

    public static void registerAccessory(Item item, Accessory accessory) {
        REGISTER.put(item, accessory);
    }

    @Nullable
    public static Accessory getAccessory(ItemStack stack) {
        return AccessoriesAPI.getAccessory(stack.getItem());
    }

    @Nullable
    public static Accessory getAccessory(Item item) {
        return REGISTER.get(item);
    }

    public static Accessory getOrDefaultAccessory(ItemStack stack) {
        Accessory accessory = REGISTER.get(stack.getItem());
        if (accessory == null) {
            accessory = stack.has(AccessoriesDataComponents.NESTED_ACCESSORIES) ? DEFAULT_NEST : DEFAULT;
        }
        return accessory;
    }

    public static Accessory getOrDefaultAccessory(Item item) {
        return REGISTER.getOrDefault(item, DEFAULT);
    }

    public static Accessory defaultAccessory() {
        return DEFAULT;
    }

    public static boolean isDefaultAccessory(Accessory accessory) {
        return accessory == DEFAULT || accessory == DEFAULT_NEST;
    }

    public static boolean isValidAccessory(ItemStack stack, Level level) {
        return AccessoriesAPI.isValidAccessory(stack, level, null);
    }

    public static boolean isValidAccessory(ItemStack stack, Level level, @Nullable LivingEntity entity) {
        return !AccessoriesAPI.isDefaultAccessory(AccessoriesAPI.getOrDefaultAccessory(stack)) || !AccessoriesAPI.getStackSlotTypes(level, entity, stack).isEmpty();
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, SlotReference slotReference) {
        return AccessoriesAPI.getAttributeModifiers(stack, slotReference, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, SlotReference slotReference, boolean useTooltipCheck) {
        return AccessoriesAPI.getAttributeModifiers(stack, slotReference.entity(), slotReference.slotName(), slotReference.slot(), useTooltipCheck);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, String slotName, int slot) {
        return AccessoriesAPI.getAttributeModifiers(stack, null, slotName, slot);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, @Nullable LivingEntity entity, String slotName, int slot) {
        return AccessoriesAPI.getAttributeModifiers(stack, entity, slotName, slot, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, @Nullable LivingEntity entity, String slotName, int slot, boolean hideTooltipIfDisabled) {
        SlotReference slotReference = SlotReference.of(entity, slotName, slot);
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference);
        AccessoryNestUtils.recursiveStackConsumption(stack, slotReference, (innerStack, innerRef) -> {
            AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)innerStack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
            if (!hideTooltipIfDisabled || component.showInTooltip()) {
                component.gatherAttributes((SlotReference)innerRef, builder);
            }
        });
        if (entity != null) {
            Accessory accessory = AccessoriesAPI.getAccessory(stack);
            if (accessory != null) {
                accessory.getDynamicModifiers(stack, slotReference, builder);
            }
            ((AdjustAttributeModifierCallback)AdjustAttributeModifierCallback.EVENT.invoker()).adjustAttributes(stack, slotReference, builder);
        }
        return builder;
    }

    public static void addAttribute(ItemStack stack, String slotName, Holder<Attribute> attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation, boolean isStackable) {
        stack.update(AccessoriesDataComponents.ATTRIBUTES, (Object)new AccessoryItemAttributeModifiers(List.of(), true), modifiers -> modifiers.withModifierAdded(attribute, new AttributeModifier(location, amount, operation), slotName, isStackable));
    }

    public static ResourceLocation createSlotLocation(SlotType slotType, int index) {
        return AccessoriesAPI.createSlotLocation(slotType.name(), index);
    }

    public static ResourceLocation createSlotLocation(String slotName, int index) {
        return Accessories.of(slotName.replace(":", "_") + "/" + index);
    }

    public static boolean canInsertIntoSlot(ItemStack stack, SlotReference reference) {
        SlotType slotType = reference.type();
        if (slotType == null) {
            throw new IllegalStateException("Unable to get the needed SlotType from the SlotReference passed within `canInsertIntoSlot`! [Name: " + reference.slotName() + "]");
        }
        return AccessoriesAPI.getPredicateResults(slotType.validators(), reference.entity().level(), reference.entity(), slotType, 0, stack) && AccessoriesAPI.canEquip(stack, reference);
    }

    public static boolean canEquip(ItemStack stack, SlotReference reference) {
        TriState result = ((CanEquipCallback)CanEquipCallback.EVENT.invoker()).canEquip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoriesAPI.getOrDefaultAccessory(stack).canEquip(stack, reference);
    }

    public static boolean canUnequip(ItemStack stack, SlotReference reference) {
        TriState result = ((CanUnequipCallback)CanUnequipCallback.EVENT.invoker()).canUnequip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoriesAPI.getOrDefaultAccessory(stack).canUnequip(stack, reference);
    }

    public static Collection<SlotType> getValidSlotTypes(LivingEntity entity, ItemStack stack) {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            Map<String, AccessoriesContainer> containers = capability.getContainers();
            block0: for (SlotType value : slots.values()) {
                if (!containers.containsKey(value.name())) continue;
                AccessoriesContainer container = containers.get(value.name());
                int size = containers.get(value.name()).getSize();
                if (size == 0) {
                    size = 1;
                }
                for (int i = 0; i < size; ++i) {
                    SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                    if (!AccessoriesAPI.canInsertIntoSlot(stack, reference)) continue;
                    validSlots.add(value);
                    continue block0;
                }
            }
        }
        return validSlots;
    }

    public static Collection<SlotType> getStackSlotTypes(Level level, ItemStack stack) {
        return AccessoriesAPI.getStackSlotTypes(level, null, stack);
    }

    public static Collection<SlotType> getStackSlotTypes(LivingEntity entity, ItemStack stack) {
        return AccessoriesAPI.getStackSlotTypes(entity.level(), entity, stack);
    }

    public static Collection<SlotType> getStackSlotTypes(Level level, @Nullable LivingEntity entity, ItemStack stack) {
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        for (SlotType value : SlotTypeLoader.getSlotTypes(level).values()) {
            if (!AccessoriesAPI.getPredicateResults(value.validators(), level, entity, value, 0, stack)) continue;
            validSlots.add(value);
        }
        return validSlots;
    }

    public static Collection<SlotType> getUsedSlotsFor(Player player) {
        return AccessoriesAPI.getUsedSlotsFor((LivingEntity)player, (Container)player.getInventory());
    }

    public static Collection<SlotType> getUsedSlotsFor(LivingEntity entity, Container container) {
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability == null) {
            return Set.of();
        }
        HashSet<SlotType> slots = new HashSet<SlotType>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            slots.addAll(AccessoriesAPI.getValidSlotTypes(entity, stack));
        }
        for (SlotEntryReference ref : capability.getAllEquipped()) {
            slots.addAll(AccessoriesAPI.getValidSlotTypes(entity, ref.stack()));
        }
        slots.addAll(SlotTypeLoader.getUsedSlotsByRegistryItem(entity));
        return slots;
    }

    public static void breakStack(SlotReference reference) {
        AccessoriesNetworking.sendToTrackingAndSelf((Entity)reference.entity(), AccessoryBreak.of(reference));
    }

    @Nullable
    public static SlotBasedPredicate getPredicate(ResourceLocation location) {
        return PREDICATE_REGISTRY.get(location);
    }

    public static void registerPredicate(ResourceLocation location, SlotBasedPredicate predicate) {
        if (PREDICATE_REGISTRY.containsKey(location)) {
            LOGGER.warn("[AccessoriesAPI]: A SlotBasedPredicate attempted to be registered but a duplicate entry existed already! [Id: {}]", (Object)location);
            return;
        }
        PREDICATE_REGISTRY.put(location, predicate);
    }

    public static boolean getPredicateResults(Set<ResourceLocation> predicateIds, Level level, SlotType slotType, int index, ItemStack stack) {
        return AccessoriesAPI.getPredicateResults(predicateIds, level, null, slotType, index, stack);
    }

    public static boolean getPredicateResults(Set<ResourceLocation> predicateIds, Level level, @Nullable LivingEntity entity, SlotType slotType, int index, ItemStack stack) {
        TriState result = TriState.DEFAULT;
        for (ResourceLocation predicateId : predicateIds) {
            SlotBasedPredicate predicate = AccessoriesAPI.getPredicate(predicateId);
            if (predicate == null) continue;
            if (predicate instanceof EntityBasedPredicate) {
                EntityBasedPredicate entityBasedPredicate = (EntityBasedPredicate)predicate;
                result = entityBasedPredicate.isValid(level, entity, slotType, index, stack);
            } else {
                result = predicate.isValid(level, slotType, index, stack);
            }
            if (result == TriState.DEFAULT) continue;
            break;
        }
        return result.orElse(false);
    }

    public static TagKey<Item> getSlotTag(SlotType slotType) {
        ResourceLocation location = UniqueSlotHandling.isUniqueSlot(slotType.name()) ? ResourceLocation.parse((String)slotType.name()) : Accessories.of(slotType.name());
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
    }

    static {
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.ALL_PREDICATE_ID, (level, slotType, i, stack) -> TriState.TRUE);
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.NONE_PREDICATE_ID, (level, slotType, i, stack) -> TriState.FALSE);
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.TAG_PREDICATE_ID, (level, slotType, i, stack) -> stack.is(AccessoriesAPI.getSlotTag(slotType)) || stack.is(AccessoriesTags.ANY_TAG) ? TriState.TRUE : TriState.DEFAULT);
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.RELEVANT_PREDICATE_ID, (level, slotType, i, stack) -> {
            boolean bl = !AccessoriesAPI.getAttributeModifiers(stack, null, slotType.name(), i).getAttributeModifiers(false).isEmpty();
            return bl ? TriState.TRUE : TriState.DEFAULT;
        });
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.COMPONENT_PREDICATE_ID, (level, slotType, index, stack) -> {
            if (stack.has(AccessoriesDataComponents.SLOT_VALIDATION)) {
                AccessorySlotValidationComponent slotValidationData = (AccessorySlotValidationComponent)stack.get(AccessoriesDataComponents.SLOT_VALIDATION);
                String name = slotType.name();
                Set<String> invalidSlots = slotValidationData.invalidSlotOverrides();
                for (String invalidSlot : invalidSlots) {
                    if (!name.equals(invalidSlot)) continue;
                    return TriState.FALSE;
                }
                Set<String> validSlots = slotValidationData.validSlotOverrides();
                for (String validSlot : validSlots) {
                    if (validSlot.equals("any")) {
                        return TriState.TRUE;
                    }
                    if (!name.equals(validSlot)) continue;
                    return TriState.TRUE;
                }
            }
            return TriState.DEFAULT;
        });
    }
}

