/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.data.providers;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.slf4j.Logger;

public abstract class BaseDataProvider<O extends DataOutput>
implements DataProvider {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public BaseDataProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        this.pathProvider = packOutput.createPathProvider(this.target(), this.type());
        this.registries = completableFuture;
    }

    public PackOutput.PathProvider pathProvider() {
        return this.pathProvider;
    }

    public final CompletableFuture<?> run(CachedOutput cachedOutput) {
        return this.registries.thenCompose(provider -> this.run(cachedOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput cachedOutput, HolderLookup.Provider provider) {
        O output = this.buildOutput(cachedOutput, provider);
        this.buildData(provider, output);
        return CompletableFuture.allOf((CompletableFuture[])output.futures().toArray(CompletableFuture[]::new));
    }

    public abstract String getName();

    protected abstract String type();

    protected abstract PackOutput.Target target();

    protected abstract O buildOutput(CachedOutput var1, HolderLookup.Provider var2);

    protected abstract void buildData(HolderLookup.Provider var1, O var2);

    public static interface DataOutput {
        public Collection<CompletableFuture<?>> futures();
    }
}

