/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.client.rendering.CustomDataRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryItemCosmeticOverride;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.RecordArgumentTypeInfo;
import io.wispforest.accessories.commands.ResourceExtendedArgument;
import io.wispforest.accessories.commands.SlotArgumentType;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class AccessoriesCommands {
    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.livingEntities.nonLiving"));
    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Slot Type"));
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.translatableEscape((String)"commands.attribute.failed.modifier_already_present_itemstack", (Object[])new Object[]{var1, var2, var3}));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.translatableEscape((String)"commands.attribute.failed.no_modifier_itemstack", (Object[])new Object[]{var1, var2, var3}));

    public static void registerCommandArgTypes() {
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
    }

    public static LivingEntity getOrThrowLivingEntity(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(ctx, (String)"entity");
        if (!(entity instanceof LivingEntity)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity;
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.literal((String)"accessories").requires(commandSourceStack -> commandSourceStack.hasPermission(2));
        if (Accessories.DEBUG) {
            ((LiteralArgumentBuilder)base.then(Commands.literal((String)"create-renderer-stack").then(Commands.argument((String)"custom_name", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)context)).then(Commands.argument((String)"renderer_id", (ArgumentType)ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)Commands.argument((String)"item_model_id", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"is_bundle", (ArgumentType)BoolArgumentType.bool()).executes(AccessoriesCommands::createRenderStack))).executes(AccessoriesCommands::createRenderStack)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"listen-to-renderer").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> {
                ResourceLocation id = (ResourceLocation)ctx.getArgument("id", ResourceLocation.class);
                CustomRendererLoader.constantFileResolving(((CommandSourceStack)ctx.getSource()).getServer(), id);
                return 1;
            }))).executes(ctx -> {
                CustomRendererLoader.constantFileResolving(((CommandSourceStack)ctx.getSource()).getServer(), null);
                return 1;
            }));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.literal((String)"edit").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(ctx -> {
            Accessories.askPlayerForVariant(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), AccessoriesCommands.getOrThrowLivingEntity((CommandContext<CommandSourceStack>)ctx));
            return 1;
        }))).executes(ctx -> {
            Accessories.askPlayerForVariant(((CommandSourceStack)ctx.getSource()).getPlayerOrException());
            return 1;
        }))).then(Commands.literal((String)"nest").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            ItemStack innerStack = ItemArgument.getItem((CommandContext)ctx, (String)"item").createItemStack(1, false);
            stack.update(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)AccessoryNestContainerContents.EMPTY, data -> data.addStack(innerStack));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"slot").then(((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)"valid").then(Commands.argument((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(0, (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandContext<CommandSourceStack>)ctx))))).then(Commands.literal((String)"invalid").then(Commands.argument((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(1, (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.literal((String)"valid").then(Commands.argument((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(2, (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandContext<CommandSourceStack>)ctx))))).then(Commands.literal((String)"invalid").then(Commands.argument((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(3, (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandContext<CommandSourceStack>)ctx))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"stack-sizing").then(Commands.literal((String)"useStackSize").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Boolean bl = (Boolean)ctx.getArgument("value", Boolean.class);
            player.getMainHandItem().update(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.useStackSize(bl));
            return 1;
        })))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Integer size = (Integer)ctx.getArgument("value", Integer.class);
            player.getMainHandItem().update(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.sizeOverride(size));
            return 1;
        })))).then(Commands.literal((String)"attribute").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modifier").then(Commands.literal((String)"add").then(Commands.argument((String)"attribute", ResourceExtendedArgument.attributes(context)).then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).then(AccessoriesCommands.createAddLiteral("add_value"))).then(AccessoriesCommands.createAddLiteral("add_multiplied_base"))).then(AccessoriesCommands.createAddLiteral("add_multiplied_total"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"attribute", ResourceExtendedArgument.attributes(context)).then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> AccessoriesCommands.removeModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"id"))))))).then(Commands.literal((String)"get").then(Commands.argument((String)"attribute", ResourceExtendedArgument.attributes(context)).then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> AccessoriesCommands.getAttributeModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"id"), 1.0))).then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> AccessoriesCommands.getAttributeModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"scale")))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"log").then(Commands.literal((String)"slots").executes(ctx -> {
            LOGGER.info("All given Slots registered:");
            for (SlotType slotType : SlotTypeLoader.getSlotTypes((Level)((CommandSourceStack)ctx.getSource()).getLevel()).values()) {
                LOGGER.info(slotType.toString());
            }
            return 1;
        }))).then(Commands.literal((String)"groups").executes(ctx -> {
            LOGGER.info("All given Slot Groups registered:");
            for (SlotGroup group : SlotGroupLoader.getGroups((Level)((CommandSourceStack)ctx.getSource()).getLevel())) {
                LOGGER.info(group.toString());
            }
            return 1;
        }))).then(Commands.literal((String)"entity_bindings").executes(ctx -> {
            LOGGER.info("All given Entity Bindings registered:");
            EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> LOGGER.info("[{}]: {}", type, slots.keySet()));
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createAddLiteral(String literal) {
        AttributeModifier.Operation selectedValue = Arrays.stream(AttributeModifier.Operation.values()).filter(value -> value.getSerializedName().equals(literal)).findFirst().orElse(null);
        if (selectedValue == null) {
            throw new IllegalStateException("Unable to handle the given literal as its not a valid AttributeModifier Operation! [Literal: " + literal + "]");
        }
        return (LiteralArgumentBuilder)Commands.literal((String)literal).then(Commands.argument((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).then(Commands.argument((String)"isStackable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> AccessoriesCommands.addModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value"), selectedValue, SlotArgumentType.getSlot((CommandContext<CommandSourceStack>)ctx, "slot"), BoolArgumentType.getBool((CommandContext)ctx, (String)"isStackable")))));
    }

    private static int getAttributeModifier(CommandSourceStack commandSourceStack, LivingEntity livingEntity, Holder<Attribute> holder, ResourceLocation resourceLocation, double d) throws CommandSyntaxException {
        ItemStack stack = livingEntity.getMainHandItem();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        AttributeModifier modifier = component.getModifier(holder, resourceLocation);
        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)stack.getDisplayName(), (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)resourceLocation);
        }
        double e = modifier.amount();
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.attribute.modifier.value.get.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName(), e}), false);
        return (int)(e * d);
    }

    private static int addModifier(CommandSourceStack commandSourceStack, LivingEntity livingEntity, Holder<Attribute> holder, ResourceLocation resourceLocation, double d, AttributeModifier.Operation operation, String slotName, boolean isStackable) throws CommandSyntaxException {
        ItemStack stack = livingEntity.getMainHandItem();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        if (component.hasModifier(holder, resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.getDisplayName());
        }
        stack.set(AccessoriesDataComponents.ATTRIBUTES, (Object)component.withModifierAdded(holder, new AttributeModifier(resourceLocation, d, operation), slotName, isStackable));
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.attribute.modifier.add.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName()}), false);
        return 1;
    }

    private static int removeModifier(CommandSourceStack commandSourceStack, LivingEntity livingEntity, Holder<Attribute> holder, ResourceLocation location) throws CommandSyntaxException {
        MutableBoolean removedModifier = new MutableBoolean(false);
        ItemStack stack = livingEntity.getMainHandItem();
        stack.update(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY, component -> {
            int size = component.modifiers().size();
            if (size != (component = component.withoutModifier(holder, location)).modifiers().size()) {
                removedModifier.setTrue();
            }
            return component;
        });
        if (!removedModifier.getValue().booleanValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)location, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.getDisplayName());
        }
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.attribute.modifier.remove.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)location), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName()}), false);
        return 1;
    }

    private static Component getAttributeDescription(Holder<Attribute> attribute) {
        return Component.translatable((String)((Attribute)attribute.value()).getDescriptionId());
    }

    private static int adjustSlotValidationOnStack(int operation, LivingEntity player, CommandContext<CommandSourceStack> ctx) {
        String slotName = SlotArgumentType.getSlot(ctx, "slot");
        player.getMainHandItem().update(AccessoriesDataComponents.SLOT_VALIDATION, (Object)AccessorySlotValidationComponent.EMPTY, component -> switch (operation) {
            case 0 -> component.addValidSlot(slotName);
            case 1 -> component.addInvalidSlot(slotName);
            case 2 -> component.removeValidSlot(slotName);
            case 3 -> component.removeInvalidSlot(slotName);
            default -> throw new IllegalStateException("Unexpected value: " + operation);
        });
        return 1;
    }

    private static int createRenderStack(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation rendererId = (ResourceLocation)ctx.getArgument("renderer_id", ResourceLocation.class);
        ResourceLocation modelId = (ResourceLocation)ctx.getArgument("item_model_id", ResourceLocation.class);
        Component component = ComponentArgument.getComponent(ctx, (String)"custom_name");
        Item item = Items.STICK;
        try {
            if (((Boolean)ctx.getArgument("is_bundle", Boolean.class)).booleanValue()) {
                item = Items.BUNDLE;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ItemStack itemStack = item.getDefaultInstance();
        itemStack.set(DataComponents.ITEM_NAME, (Object)component);
        itemStack.set(AccessoriesDataComponents.CUSTOM_RENDERER, (Object)new AccessoryCustomRendererComponent(List.of(new CustomDataRenderer(rendererId, Map.of(), List.of(), null))));
        itemStack.set(AccessoriesDataComponents.ITEM_MODEL_OVERRIDE, (Object)new AccessoryItemCosmeticOverride(modelId));
        itemStack.set(AccessoriesDataComponents.SLOT_VALIDATION, (Object)new AccessorySlotValidationComponent(Set.of("any"), Set.of()));
        ((CommandSourceStack)ctx.getSource()).getPlayerOrException().addItem(itemStack);
        return 1;
    }
}

