/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.caching;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public abstract class EquipmentLookupCache {
    protected final Cache<ItemStackBasedPredicate, @Nullable Boolean> isEquipped = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(60L)).maximumSize(10000L).build();
    protected final Cache<ItemStackBasedPredicate, @Nullable Optional<SlotEntryReference>> firstEquipped_ACCESSORIES_ONLY = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(60L)).maximumSize(10000L).build();
    protected final Cache<ItemStackBasedPredicate, @Nullable Optional<SlotEntryReference>> firstEquipped_COSMETICALLY_OVERRIDABLE = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(60L)).maximumSize(10000L).build();
    protected final Cache<ItemStackBasedPredicate, @Nullable List<SlotEntryReference>> equipped = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(60L)).maximumSize(10000L).build();
    @Nullable
    protected List<SlotEntryReference> getAllEquipped = null;

    protected EquipmentLookupCache() {
    }

    public abstract boolean isEquipped(ItemStackBasedPredicate var1);

    @Nullable
    public abstract SlotEntryReference firstEquipped(ItemStackBasedPredicate var1, EquipmentChecking var2);

    @Nullable
    public abstract List<SlotEntryReference> getEquipped(ItemStackBasedPredicate var1);

    public abstract List<SlotEntryReference> getAllEquipped();

    public void clearCache() {
        this.isEquipped.invalidateAll();
        this.firstEquipped_ACCESSORIES_ONLY.invalidateAll();
        this.firstEquipped_COSMETICALLY_OVERRIDABLE.invalidateAll();
        this.equipped.invalidateAll();
        this.getAllEquipped = null;
    }
}

