/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.HolderLookup;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiListBoxBase;

public class ConfigTypeArray
extends ConfigTypeConveration {
    public Object readElement(HolderLookup.Provider provider, Object defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
        Class<?> clazz = defaultValue.getClass().getComponentType();
        ConfigKey arrayKey = ConfigKey.ofArrayType(key, side);
        if (element.isJsonArray()) {
            JsonArray array = (JsonArray)element;
            int size = Math.min(array.size(), Array.getLength(defaultValue));
            Object object = Array.newInstance(clazz, size);
            for (int i = 0; i < size; ++i) {
                arrayKey.read(provider, true, ignoreRestart, array.get(i), side);
                Array.set(object, i, arrayKey.copy(provider, side));
            }
            return object;
        }
        int size = Array.getLength(defaultValue);
        Object object = Array.newInstance(clazz, size);
        for (int i = 0; i < size; ++i) {
            arrayKey.forceValue(Array.get(object, i), side);
            Array.set(object, i, arrayKey.copy(provider, side));
        }
        return object;
    }

    public JsonElement writeElement(HolderLookup.Provider provider, Object value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
        int length = Array.getLength(value);
        JsonArray array = new JsonArray();
        ConfigKey arrayKey = ConfigKey.ofArrayType(key, side);
        for (int i = 0; i < length; ++i) {
            arrayKey.forceValue(Array.get(value, i), side);
            array.add(arrayKey.write(provider, true, ignoreRestart, side));
        }
        return array;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        parent.add((GuiControl)new GuiListBoxBase("data", false, new ArrayList()).setDim(50, 150).setExpandable());
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void loadValue(Object value, Object defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
        if (!box.isEmpty()) {
            box.clear();
        }
        ConfigKey arrayKey = ConfigKey.ofArrayType(key, side);
        int length = Array.getLength(value);
        ArrayList<GuiConfigSubControl> controls = new ArrayList<GuiConfigSubControl>(length);
        for (int i = 0; i < length; ++i) {
            GuiConfigSubControl c = arrayKey.create(configParent, "" + i, side);
            arrayKey.forceValue(Array.get(value, i), side);
            arrayKey.load(configParent, c, side);
            controls.add(c);
        }
        box.addAllItems(controls);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected Object saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        ConfigKey arrayKey = ConfigKey.ofArrayType(key, side);
        GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
        Object value = Array.newInstance(arrayKey.field().getType(), box.size());
        for (int i = 0; i < box.size(); ++i) {
            arrayKey.save((GuiConfigSubControl)box.get(i), configParent, side);
            Array.set(value, i, arrayKey.copy(configParent.provider(), side));
        }
        return value;
    }

    public Object set(ConfigKey key, Object value) {
        return value;
    }

    public boolean areEqual(Object one, Object two, ConfigKey key, Side side) {
        int lengthOne = Array.getLength(one);
        int lengthTwo = Array.getLength(two);
        ConfigKey arrayKey = ConfigKey.ofArrayType(key, side);
        ConfigTypeConveration converation = arrayKey.converation();
        if (lengthOne != lengthTwo) {
            return false;
        }
        for (int i = 0; i < lengthOne; ++i) {
            Object entryOne = Array.get(one, i);
            Object entryTwo = Array.get(two, i);
            if (converation != null) {
                arrayKey.forceValue(entryOne, side);
                if (converation.areEqual(entryOne, entryTwo, arrayKey, side)) continue;
                return false;
            }
            if (converation != null || key.getRegistry().equals(entryOne, entryTwo, side)) continue;
            return false;
        }
        return true;
    }
}

