/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.screen.splash;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.client.screen.splash.LiteralSplash;
import com.teamabnormals.blueprint.client.screen.splash.Splash;
import com.teamabnormals.blueprint.core.Blueprint;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;

public abstract class SplashProvider
implements DataProvider {
    private final String modId;
    private final PackOutput packOutput;
    private final LinkedList<Splash> splashes = new LinkedList();

    protected SplashProvider(String modId, PackOutput packOutput) {
        this.modId = modId;
        this.packOutput = packOutput;
    }

    protected void add(String splash) {
        this.add(new LiteralSplash(splash));
    }

    protected void add(Splash splash) {
        this.splashes.add(splash);
    }

    protected abstract void registerSplashes();

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        this.splashes.clear();
        this.registerSplashes();
        DataResult dataResult = Splash.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.splashes);
        Path resolvedPath = this.packOutput.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modId).resolve("texts/blueprint/splashes.json");
        try {
            Optional error = dataResult.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)((JsonElement)dataResult.result().get()), (Path)resolvedPath);
        }
        catch (JsonParseException e) {
            Blueprint.LOGGER.error("Couldn't save splashes {}", (Object)resolvedPath, (Object)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    public String getName() {
        return "Blueprint Splashes: " + this.modId;
    }
}

