/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.core.registry.BlueprintPlacementModifierTypes;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class BetterNoiseBasedCountPlacement
extends PlacementModifier {
    public static final MapCodec<BetterNoiseBasedCountPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NormalNoise.NoiseParameters.CODEC.fieldOf("noise").forGetter(placement -> placement.noiseParameters), (App)Codec.INT.fieldOf("noise_to_count_ratio").forGetter(placement -> placement.noiseToCountRatio), (App)Codec.DOUBLE.fieldOf("noise_offset").orElse((Object)0.0).forGetter(placement -> placement.noiseOffset)).apply((Applicative)instance, BetterNoiseBasedCountPlacement::new));
    private final Holder<NormalNoise.NoiseParameters> noiseParameters;
    private final int noiseToCountRatio;
    private final double noiseOffset;
    private volatile boolean initialized;
    private NormalNoise noise;

    public BetterNoiseBasedCountPlacement(Holder<NormalNoise.NoiseParameters> noiseParameters, int noiseToCountRatio, double noiseOffset) {
        this.noiseParameters = noiseParameters;
        this.noiseToCountRatio = noiseToCountRatio;
        this.noiseOffset = noiseOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        if (!this.initialized) {
            BetterNoiseBasedCountPlacement betterNoiseBasedCountPlacement = this;
            synchronized (betterNoiseBasedCountPlacement) {
                if (!this.initialized) {
                    this.noise = NormalNoise.create((RandomSource)WorldgenRandom.Algorithm.LEGACY.newInstance(context.getLevel().getSeed()).forkPositional().fromHashOf(((ResourceKey)this.noiseParameters.unwrapKey().orElseThrow()).location()), (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)this.noiseParameters.value()));
                    this.initialized = true;
                }
            }
        }
        return IntStream.range(0, (int)Math.ceil((this.noise.getValue((double)pos.getX(), 0.0, (double)pos.getZ()) + this.noiseOffset) * (double)this.noiseToCountRatio)).mapToObj(i -> pos);
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)BlueprintPlacementModifierTypes.BETTER_NOISE_BASED_COUNT.get();
    }
}

