/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder;

import com.teamabnormals.blueprint.common.remolder.Remolder;
import com.teamabnormals.blueprint.common.remolder.Remolding;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import com.teamabnormals.blueprint.common.remolder.data.ReturnType;
import com.teamabnormals.blueprint.common.remolder.data.VariableDataVisitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class RemoldingCompiler
extends ClassLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExportEntry[] exports;

    public RemoldingCompiler(ClassLoader parent, ExportEntry ... exports) {
        super(parent);
        this.exports = exports;
    }

    private static String formatIdentifierForClassName(String string) {
        StringBuilder result = new StringBuilder();
        boolean capitalizeNextLetter = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                result.append(capitalizeNextLetter ? Character.toUpperCase(c) : c);
                capitalizeNextLetter = false;
                continue;
            }
            capitalizeNextLetter = true;
        }
        return result.toString();
    }

    private static String formatIdentifierForExport(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            result.append(Character.isLetterOrDigit(c) ? Character.valueOf(c) : "_");
        }
        return result.toString();
    }

    public <T> Remolding<T> compile(String identifier, DataType<?> dataType, Molding.Factory moldingFactory, Remolder ... remolders) throws Throwable {
        return this.compile(remolders[0].getClass().getSimpleName(), identifier, dataType, moldingFactory, remolders);
    }

    public <T> Remolding<T> compile(String type, String identifier, DataType<?> dataType, Molding.Factory moldingFactory, Remolder ... remolders) throws Throwable {
        int remoldersLength = remolders.length;
        if (remoldersLength == 0) {
            throw new IllegalArgumentException("Cannot compile an empty array of Remolders");
        }
        ClassWriter classWriter = new ClassWriter(3);
        String name = RemoldingCompiler.formatIdentifierForClassName(identifier) + type + "Remolding" + System.nanoTime();
        String typeDescriptor = dataType.getType().getDescriptor();
        classWriter.visit(61, 1, name, "L" + name + "<" + typeDescriptor + ">;Lcom/teamabnormals/blueprint/common/remolder/Remolding<" + typeDescriptor + ">;", "java/lang/Object", new String[]{"com/teamabnormals/blueprint/common/remolder/Remolding"});
        MethodVisitor toString = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        toString.visitLdcInsn((Object)(identifier + " (" + name + ")"));
        toString.visitInsn(176);
        toString.visitMaxs(0, 0);
        toString.visitEnd();
        String realApplyDescriptor = "(Lcom/mojang/serialization/DynamicOps;" + typeDescriptor + typeDescriptor + ")Lcom/mojang/datafixers/util/Pair;";
        String applySignature = "(Lcom/mojang/serialization/DynamicOps<" + typeDescriptor + ">;" + typeDescriptor + typeDescriptor + ")Lcom/mojang/datafixers/util/Pair<" + typeDescriptor + typeDescriptor + ">;";
        Molding apply = moldingFactory.create(classWriter.visitMethod(1, "apply", realApplyDescriptor, applySignature, null), name, VariableDataVisitor.THIS, 0);
        VariableDataVisitor.THIS.allocate(apply);
        VariableDataVisitor.OPS.allocate(apply);
        VariableDataVisitor.ROOT.allocate(apply);
        VariableDataVisitor.META.allocate(apply);
        for (Remolder remolder : remolders) {
            remolder.remold(apply);
        }
        VariableDataVisitor.ROOT.visit(apply);
        VariableDataVisitor.META.visit(apply);
        apply.visitMethodInsn(184, "com/mojang/datafixers/util/Pair", "of", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/mojang/datafixers/util/Pair;", false);
        apply.visitInsn(176);
        apply.visitMaxs(0, 0);
        apply.visitEnd();
        ArrayList<VariableDataVisitor.Provided<?>> providedVariables = apply.getProvidedVariables();
        int providedVariableCount = providedVariables.size();
        Class[] parameterTypes = new Class[providedVariableCount];
        Object[] parameterValues = new Object[providedVariableCount];
        StringBuilder constructorDescriptor = new StringBuilder();
        constructorDescriptor.append('(');
        for (int i = 0; i < providedVariableCount; ++i) {
            VariableDataVisitor.Provided<?> provided = providedVariables.get(i);
            ReturnType variableReturnType = provided.getReturnType();
            parameterTypes[i] = ((DataType)variableReturnType).getClazz();
            parameterValues[i] = provided.initial();
            constructorDescriptor.append(((DataType)variableReturnType).getType().getDescriptor());
        }
        constructorDescriptor.append(")V");
        MethodVisitor constructor = classWriter.visitMethod(1, "<init>", constructorDescriptor.toString(), null, null);
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        int i = 0;
        while (i < providedVariableCount) {
            VariableDataVisitor.Provided<?> provided = providedVariables.get(i);
            String fieldName = provided.name();
            Type variableType = ((DataType)provided.getReturnType()).getType();
            String descriptor = variableType.getDescriptor();
            classWriter.visitField(2, fieldName, descriptor, null, null);
            constructor.visitVarInsn(25, 0);
            constructor.visitVarInsn(variableType.getOpcode(21), ++i);
            constructor.visitFieldInsn(181, name, fieldName, descriptor);
        }
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        constructor.visitEnd();
        MethodVisitor bridgeApply = classWriter.visitMethod(4161, "apply", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;Ljava/lang/Object;)Lcom/mojang/datafixers/util/Pair;", null, null);
        bridgeApply.visitVarInsn(25, 0);
        bridgeApply.visitVarInsn(25, 1);
        bridgeApply.visitVarInsn(25, 2);
        String dataTypeInternalName = dataType.getInternalName();
        bridgeApply.visitTypeInsn(192, dataTypeInternalName);
        bridgeApply.visitVarInsn(25, 3);
        bridgeApply.visitTypeInsn(192, dataTypeInternalName);
        bridgeApply.visitMethodInsn(182, name, "apply", realApplyDescriptor, false);
        bridgeApply.visitInsn(176);
        bridgeApply.visitMaxs(0, 0);
        bridgeApply.visitEnd();
        byte[] data = classWriter.toByteArray();
        for (ExportEntry export : this.exports) {
            if (!export.predicate.test(identifier)) continue;
            String exportName = RemoldingCompiler.formatIdentifierForExport(identifier) + ".class";
            try {
                Files.write(Paths.get(export.folder + "/" + exportName, new String[0]), data, new OpenOption[0]);
            }
            catch (IOException exception) {
                LOGGER.error("Failed to export Remolder class '{}' that matched '{}': {}", (Object)exportName, (Object)export.pattern, (Object)exception);
            }
        }
        return (Remolding)this.defineClass(name, data, 0, data.length).getConstructor(parameterTypes).newInstance(parameterValues);
    }

    public record ExportEntry(String folder, String pattern, Predicate<String> predicate) {
    }
}

