/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.codec.NullableFieldCodec;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleTagStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.WeightedStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.WeightedTagStructureRepaletter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public record StructureRepaletterEntry(HolderSet<Structure> structures, Optional<HolderSet<StructurePieceType>> pieces, boolean shouldApplyToAfterPlace, int priority, Optional<StructureRepaletter.Condition> condition, List<StructureRepaletter> repaletters) {
    public static final Codec<StructureRepaletterEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).fieldOf("structures").forGetter(entry -> entry.structures), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE_PIECE).optionalFieldOf("pieces").forGetter(entry -> entry.pieces), (App)Codec.BOOL.optionalFieldOf("should_apply_to_after_place", (Object)false).forGetter(entry -> entry.shouldApplyToAfterPlace), (App)NullableFieldCodec.nullable("priority", Codec.INT, 100).forGetter(entry -> entry.priority), (App)StructureRepaletter.Condition.CODEC.optionalFieldOf("condition").forGetter(entry -> entry.condition), (App)Codec.either(StructureRepaletter.CODEC, (Codec)ExtraCodecs.nonEmptyList((Codec)StructureRepaletter.CODEC.listOf())).xmap(either -> (List)either.map(List::of, repalleters -> repalleters), repaletters -> repaletters.size() == 1 ? Either.left((Object)((StructureRepaletter)repaletters.getFirst())) : Either.right((Object)repaletters)).fieldOf("repaletter").forGetter(entry -> entry.repaletters)).apply((Applicative)instance, StructureRepaletterEntry::new));

    public StructureRepaletterEntry(HolderSet<Structure> structures, Optional<HolderSet<StructurePieceType>> pieces, boolean shouldApplyToAfterPlace, int priority, Optional<StructureRepaletter.Condition> condition, StructureRepaletter repaletter) {
        this(structures, pieces, shouldApplyToAfterPlace, priority, condition, List.of(repaletter));
    }

    public StructureRepaletterEntry(HolderSet<Structure> structures, Optional<HolderSet<StructurePieceType>> pieces, boolean shouldApplyToAfterPlace, int priority, StructureRepaletter.Condition condition, StructureRepaletter repaletter) {
        this(structures, pieces, shouldApplyToAfterPlace, priority, Optional.of(condition), repaletter);
    }

    public StructureRepaletterEntry(HolderSet<Structure> structures, Optional<HolderSet<StructurePieceType>> pieces, boolean shouldApplyToAfterPlace, StructureRepaletter repaletter) {
        this(structures, pieces, shouldApplyToAfterPlace, 100, Optional.empty(), repaletter);
    }

    public StructureRepaletterEntry(HolderSet<Structure> structures, Optional<HolderSet<StructurePieceType>> pieces, boolean shouldApplyToAfterPlace, StructureRepaletter.Condition condition, StructureRepaletter repaletter) {
        this(structures, pieces, shouldApplyToAfterPlace, 100, Optional.of(condition), repaletter);
    }

    public static Builder repalette() {
        return new Builder();
    }

    public static SimpleStructureRepaletter simple(Block replacesBlock, Block replacesWith) {
        return new SimpleStructureRepaletter(replacesBlock, replacesWith);
    }

    public static SimpleTagStructureRepaletter simple(TagKey<Block> replacesBlocks, Block replacesWith) {
        return new SimpleTagStructureRepaletter(replacesBlocks, replacesWith);
    }

    @SafeVarargs
    public static WeightedStructureRepaletter weighted(Block replacesBlock, WeightedEntry.Wrapper<Block> ... weightedPairs) {
        return new WeightedStructureRepaletter(replacesBlock, (WeightedRandomList<WeightedEntry.Wrapper<Block>>)WeightedRandomList.create(List.of(weightedPairs)));
    }

    @SafeVarargs
    public static WeightedTagStructureRepaletter weighted(TagKey<Block> replacesBlocks, WeightedEntry.Wrapper<Block> ... weightedPairs) {
        return new WeightedTagStructureRepaletter(replacesBlocks, (WeightedRandomList<WeightedEntry.Wrapper<Block>>)WeightedRandomList.create(List.of(weightedPairs)));
    }

    @SafeVarargs
    public static HolderSet<Structure> holder(HolderGetter<Structure> structures, ResourceKey<Structure> ... keys) {
        return HolderSet.direct(Stream.of(keys).map(arg_0 -> structures.getOrThrow(arg_0)).collect(Collectors.toList()));
    }

    public static final class Builder {
        private Optional<StructureRepaletter.Condition> condition = Optional.empty();
        private Optional<HolderSet<StructurePieceType>> pieces = Optional.empty();
        private final List<StructureRepaletter> repaletters = new ArrayList<StructureRepaletter>();
        private boolean applyToAfterPlace;
        private int priority = 100;

        public Builder condition(StructureRepaletter.Condition condition) {
            this.condition = Optional.of(condition);
            return this;
        }

        public Builder pieces(HolderSet<StructurePieceType> pieces) {
            this.pieces = Optional.of(pieces);
            return this;
        }

        public Builder repaletters(StructureRepaletter ... repaletters) {
            List<StructureRepaletter> list = this.repaletters;
            for (StructureRepaletter repaletter : repaletters) {
                list.add(repaletter);
            }
            return this;
        }

        public Builder applyToAfterPlace() {
            this.applyToAfterPlace = true;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public StructureRepaletterEntry select(HolderSet<Structure> structures) {
            return new StructureRepaletterEntry(structures, this.pieces, this.applyToAfterPlace, this.priority, this.condition, this.repaletters);
        }
    }
}

