/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.core.endimator.EndimatorModelPart;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorPartPose;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDefinition;
import net.minecraft.client.model.geom.builders.CubeListBuilder;

public final class EndimatorPartDefinition {
    private final List<CubeDefinition> cubes;
    private final EndimatorPartPose partPose;
    private final Map<String, EndimatorPartDefinition> children = Maps.newHashMap();

    private EndimatorPartDefinition(List<CubeDefinition> cubes, EndimatorPartPose partPose) {
        this.cubes = cubes;
        this.partPose = partPose;
    }

    public static EndimatorPartDefinition root() {
        return new EndimatorPartDefinition((List<CubeDefinition>)ImmutableList.of(), new EndimatorPartPose());
    }

    public EndimatorPartDefinition addOrReplaceChild(String name, CubeListBuilder cubeListBuilder, EndimatorPartPose pose) {
        EndimatorPartDefinition partDefinition = new EndimatorPartDefinition(cubeListBuilder.getCubes(), pose);
        EndimatorPartDefinition previous = this.children.put(name, partDefinition);
        if (previous != null) {
            previous.children.putAll(partDefinition.children);
        }
        return partDefinition;
    }

    public EndimatorPartDefinition addOrReplaceChild(String name, CubeListBuilder cubeListBuilder, PartPose pose) {
        return this.addOrReplaceChild(name, cubeListBuilder, new EndimatorPartPose().setPartPose(pose));
    }

    public EndimatorModelPart bake(int xTexSize, int yTexSize) {
        Object2ObjectArrayMap bakedChildren = this.children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EndimatorPartDefinition)entry.getValue()).bake(xTexSize, yTexSize), (modelPart, modelPart2) -> modelPart, Object2ObjectArrayMap::new));
        List bakedCubes = (List)this.cubes.stream().map(cubeDefinition -> cubeDefinition.bake(xTexSize, yTexSize)).collect(ImmutableList.toImmutableList());
        EndimatorModelPart modelpart = new EndimatorModelPart(bakedCubes, (Map<String, ModelPart>)bakedChildren);
        modelpart.setInitialPose(this.partPose);
        modelpart.loadPose(this.partPose);
        return modelpart;
    }

    public EndimatorPartDefinition getChild(String name) {
        return this.children.get(name);
    }
}

