/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.EndimationKeyframe;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EndimationProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modId;
    private final PackOutput.PathProvider pathProvider;
    private final ArrayList<EndimationEntry> entries = new ArrayList();

    public EndimationProvider(String modId, PackOutput packOutput) {
        this.modId = modId;
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "endimations");
    }

    public static EndimationKeyframe linear(float time, float x, float y, float z) {
        return new EndimationKeyframe(time, new EndimationKeyframe.Transform(() -> Float.valueOf(x), () -> Float.valueOf(y), () -> Float.valueOf(z)), EndimationKeyframe.LINEAR);
    }

    public static EndimationKeyframe linear(float time) {
        return EndimationProvider.linear(time, 0.0f, 0.0f, 0.0f);
    }

    public static EndimationKeyframe catmullRom(float time, float x, float y, float z) {
        return new EndimationKeyframe(time, new EndimationKeyframe.Transform(() -> Float.valueOf(x), () -> Float.valueOf(y), () -> Float.valueOf(z)), EndimationKeyframe.CATMULL_ROM);
    }

    public static EndimationKeyframe catmullRom(float time) {
        return EndimationProvider.catmullRom(time, 0.0f, 0.0f, 0.0f);
    }

    protected abstract void addEndimations();

    protected EndimationEntry endimation(String name) {
        EndimationEntry entry = new EndimationEntry(name);
        this.entries.add(entry);
        return entry;
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        ArrayList<EndimationEntry> entries = this.entries;
        entries.clear();
        this.addEndimations();
        return CompletableFuture.allOf((CompletableFuture[])this.entries.stream().map(entry -> {
            Path resolvedPath = this.pathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)entry.name));
            try {
                DataResult dataResult = Endimation.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.build());
                Optional error = dataResult.error();
                if (error.isPresent()) {
                    throw new JsonParseException(((DataResult.Error)error.get()).message());
                }
                return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)((JsonElement)dataResult.result().get()), (Path)resolvedPath);
            }
            catch (JsonParseException e) {
                LOGGER.error("Couldn't save endimation {}", (Object)resolvedPath, (Object)e);
                return CompletableFuture.completedFuture(null);
            }
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Endimation generator for " + this.modId;
    }

    protected static final class EndimationEntry
    extends Endimation.Builder {
        private final String name;

        private EndimationEntry(String name) {
            this.name = name;
        }
    }
}

